<?php 
ini_set('display_errors', 1);
include_once (GLPI_ROOT . "/inc/includes.php");
//include_once ("../../../inc/includes.php");
include_once(PLUGIN_TRT16_DIR . "/config.php");
function isHoliday(DateTime $date) {
    global $holidays;
    foreach ($holidays as $holiday) {
        if ($holiday['begin_date'] == $date->format('Y-m-d')) {
            return true;
        }
    }
    /*
    $holidays = ['2023-01-01','2023-01-02','2023-01-03','2023-01-14','2023-07-17','2023-01-06','2023-02-20','2023-02-21','2023-02-23','2023-04-05','2023-04-06','2023-04-07','2023-04-21','2023-05-01','2023-06-08','2023-08-11','2023-09-07','2023-10-12','2023-10-28','2023-11-01','2023-11-02','2023-11-15','2023-12-08','2023-12-20','2023-12-21','2023-12-22','2023-12-25','2023-12-26','2023-12-27','2023-12-28','2023-12-29'];
    foreach ($holidays as $holiday) {
        if ($holiday == $date->format('Y-m-d')) {
        return true;
        }
    }*/
    return false;
}

function isWeekend(DateTime $date) {
    //$dayOfWeek = date('N', strtotime($date));
    $dayOfWeek = date('N', strtotime($date->format('Y-m-d')));
    return ($dayOfWeek == 6 || $dayOfWeek == 7);
}

function isWorkDay(DateTime $date){
    //echo "dia da semana: " . $date . " - feriado: " . isHoliday($date) . " - fim de semana: " . isWeekend($date) . " ; <br>";
    return !isHoliday($date) && !isWeekend($date);
};

function addDays(DateTime $date, int $days) {
    //$newDate = new DateTime($date);
    $date->add(new DateInterval('P' . $days . 'D')); 
    //return $newDate->format('Y-m-d');
    return $date;
}

function subDays(DateTime $date, int $days) {
    //$newDate = new DateTime($date);
    $date->sub(new DateInterval('P' . $days . 'D')); 
    //return $newDate->format('Y-m-d');
    return $date;
}
  
function getNextWorkDay(DateTime $date){
    $nextDay = addDays($date, 1);
    while (!isWorkDay($nextDay)) {
    //echo "dia da semana: " . $nextDay . " - " . isWorkDay($nextDay) . "; <br>";
      $nextDay = addDays($nextDay, 1);
    }
    return $nextDay;
 }
  
function getPreviousWorkDay(DateTime $date){
    $previousWorkDay = subDays($date, 1);
    while (!isWorkDay($previousWorkDay)) {
        $previousWorkDay = subDays($previousWorkDay, 1);
    }
    return $previousWorkDay;
}

function setTimeToDate(DateTime $date, int $hour, int $minute) {
    // Defina a data
    $dateTime = clone $date;
  
    // Defina a hora e o minuto
    $dateTime->setTime($hour, $minute);
  
    // Retorne a nova data
    //return $dateTime->format('Y-m-d H:i:s');
    return $dateTime;
}

function setStartWorkingHours(DateTime $date){
    global $configStartWorkingHour;
    global $configStartWorkingMinute;
    return setTimeToDate($date, $configStartWorkingHour, $configStartWorkingMinute);
}

function setEndWorkingHours(DateTime $date){
    global $configEndWorkingHour;
    global $configEndWorkingMinute;
    return setTimeToDate($date, $configEndWorkingHour, $configEndWorkingMinute);
}
  
function isBeforeWorkingHours(DateTime $date){
    //$startWorkingHour = new DateTime(setStartWorkingHours($date));
    $startWorkingHour = setStartWorkingHours($date);
    //$dateTime = new DateTime($date);
    //echo "<br>Data: " . $date->format('d/m/Y H:i:s') . " antes do expediente? " . var_dump($date < $startWorkingHour) . "<br><br>";
    return $date < $startWorkingHour;
}
  
function isAfterWorkingHours(DateTime $date){
    $endWorkingHour = setEndWorkingHours($date);
    //$dateTime = new DateTime($date);
    //echo "<br>Data: " . $date->format('d/m/Y H:i:s') . " depois do expediente? " . var_dump($date > $endWorkingHour) . "<br><br>";
    return $date > $endWorkingHour;
}

function getSecondsBetweenDatetimes(DateTime $start, DateTime $end) {
    $interval = $start->diff($end);
    return $interval->h * 3600 + $interval->i * 60 + $interval->s;
}

function getMinutesBetweenDatetimes(DateTime $start, DateTime $end) {
    $interval = $start->diff($end);
    $arredondamentoSegundos = $interval->s > 40 ? 1 : 0;
    return $interval->h * 60 + $interval->i + $arredondamentoSegundos;
}

function subtractDateTimes(string $start, string $end) {
  $interval = $start->diff($end);

  return [
    'years' => $interval->y,
    'months' => $interval->m,
    'days' => $interval->d,
    'hours' => $interval->h,
    'minutes' => $interval->i,
    'seconds' => $interval->s,
  ];
}
  
function resolveDelay(DateTime $startDate, DateTime $endDate){
   // echo $startDate->format('d/m/Y H:i:s') . " , DateTime " . $endDate->format('d/m/Y H:i:s');
    //Se a datahora inicial for antes do início do expediente
    if(isBeforeWorkingHours($startDate)){
        //Considera o início do expediente do dia atual
        $startDate = setStartWorkingHours($startDate);
    //Se a datahora inicial for depois do expediente
    }else if(isAfterWorkingHours($startDate)){
        //Considera o início do expediente do dia útil seguinte
        $startDate = setStartWorkingHours(getNextWorkDay($startDate));
    }
    
    //Se a datahora final for antes do início do expediente
    if(isBeforeWorkingHours($endDate)){
        //Se a data inicio e adata fim são no mesmo dia e antes do expediente, considera o inicio do expediente do dia
        if($startDate->format('Y-m-d') == $endDate->format('Y-m-d')){
            //Considera o inicio do expediente do dia util atual
            $endDate = setStartWorkingHours($startDate);
        }else{
            //Considera o final do expediente do dia util anterior
            $endDate = setEndWorkingHours(getPreviousWorkDay($startDate));
        }
        
    //Se a datahora final for depois do expediente
    }else if(isAfterWorkingHours($endDate)){
        //Se a datahora final é menor do que a datahora inicial
        if($endDate < $startDate){
            //Considera o início do expediente do dia útil seguinte
            $endDate = setStartWorkingHours(getNextWorkDay($startDate));
        }else{
            //Considera o final do expediente do dia atual
            $endDate = setEndWorkingHours($endDate);
        }
    }
    $totalDelay = 0;
    $cont = 0;
    while ($startDate->format('Y-m-d') != $endDate->format('Y-m-d') && $cont < 50) {
      $endWorkingHour = setEndWorkingHours($startDate);
      
      //echo "Inicio: " . $startDate->format('d/m/Y H:i:s') . " - Fim: " . $endWorkingHour->format('d/m/Y H:i:s') . " = " . getMinutesBetweenDatetimes($endWorkingHour,$startDate) . "<br>";

      $totalDelay += getMinutesBetweenDatetimes($endWorkingHour,$startDate);
      $startDate = setStartWorkingHours(getNextWorkDay($startDate));
      $cont++;
    }
    $totalDelay += getMinutesBetweenDatetimes($endDate,$startDate);
    //echo "Inicio: " . $startDate->format('d/m/Y H:i:s') . " - Fim: " . $endDate->format('d/m/Y H:i:s') . " = " . getMinutesBetweenDatetimes($endDate,$startDate) . "<br>";
    return $totalDelay;
}

//$strDate1 = "2023-10-02 07:48:02";//"2023-07-14 08:15:52";
//$dateTime1 = DateTime::createFromFormat('Y-m-d H:i:s', $strDate1);
//$strDate2 = "2023-10-02 07:49:32";//'2023-07-18 10:00:00';
//$dateTime2 = DateTime::createFromFormat('Y-m-d H:i:s', $strDate2);
//echo $dateTime1->add(new DateInterval('P1D'))->format('d/m/Y');

//echo getNextWorkDay($dateTime1)->format('d/m/Y');
//echo "<br>";
//echo setStartWorkingHours(getNextWorkDay($dateTime1))->format('d/m/Y');
//echo "<br>";
//echo "tempo: " . resolveDelay($dateTime1,$dateTime2);

?>