<?php

/**
 * -------------------------------------------------------------------------
 * TRT16 plugin for GLPI
 * Copyright (C) {YEAR} by the TRT16 Development Team.
 * -------------------------------------------------------------------------
 *
 * MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * --------------------------------------------------------------------------
 */

if (!defined('GLPI_ROOT')) {
   die("Sorry. You can't access this file directly");
}

// Include bootstrap first to define constants
include_once(__DIR__ . "/inc/bootstrap.php");



// Include plugin classes
include_once(PLUGIN_TRT16_DIR . "/inc/menu.class.php");
include_once(PLUGIN_TRT16_DIR . "/inc/functions.php");
include_once(PLUGIN_TRT16_DIR . "/inc/profile.class.php");
include_once(PLUGIN_TRT16_DIR . "/inc/satisfaction.class.php");
include_once(PLUGIN_TRT16_DIR . "/inc/ticket_clone.class.php");
include_once(PLUGIN_TRT16_DIR . "/inc/user_signup.class.php");
include_once(PLUGIN_TRT16_DIR . "/inc/new_user_notification_model.class.php");
include_once(PLUGIN_TRT16_DIR . "/inc/usersignup_menu.class.php");
include_once(PLUGIN_TRT16_DIR . "/inc/consentimento_versao.class.php");
include_once(PLUGIN_TRT16_DIR . "/hook.php");

use Glpi\Plugin\Hooks;



/**
 * Init hooks of the plugin.
 * REQUIRED
 *
 * @return void
 */
function plugin_init_trt16()
{
    global $PLUGIN_HOOKS, $DB;
    
    $PLUGIN_HOOKS['csrf_compliant']['trt16'] = true;
    
   
    $plugin = new Plugin();
    
    if ($plugin->isInstalled('trt16') && $plugin->isActivated('trt16')) {


        


        // Add tabs
        Plugin::registerClass('PluginTrt16Profile', ['addtabon' => ['Profile']]);
       
        Plugin::registerClass('PluginTrt16Satisfaction', ['addtabon' => ['Ticket']]);
        Plugin::registerClass('PluginTrt16TicketClone', ['addtabon' => ['Ticket']]);

        // Add profile change hook
        $PLUGIN_HOOKS['post_item_form']['trt16'] = ['Profile', 'PluginTrt16Profile::updateRights'];
        
        // Add menu entries based on permissions
        if (Session::haveRight('plugin_trt16_user_signup', READ)) {
            $PLUGIN_HOOKS['menu_toadd']['trt16']['admin'] = 'PluginTRT16UserSignupMenu';
        }
        
        if (Session::haveRight('plugin_trt16_metrics_dashboard', READ)) {
            $PLUGIN_HOOKS['menu_toadd']['trt16']['tools'] = 'PluginTRT16Menu';
        }

        if (Session::haveRight('plugin_trt16_consentimento_versao', READ)) {
            $PLUGIN_HOOKS['menu_toadd']['trt16']['setup'] = 'PluginTRT16ConsentimentoVersao';
        }
        
        // Other hooks
        $PLUGIN_HOOKS['item_update']['trt16'] = ['Ticket' => 'plugin_trt16_ticket_update'];
        $PLUGIN_HOOKS['pre_item_update']['trt16'] = ['Ticket' => 'plugin_trt16_pre_item_update_ticket2'];
        $PLUGIN_HOOKS['display_login']['trt16'] = 'plugin_trt16_display_login';
        //$PLUGIN_HOOKS['addLeftJoin']['trt16'] = 'plugin_trt16_addLeftJoin';
        //$PLUGIN_HOOKS['addWhere']['trt16'] = 'plugin_trt16_addWhere'; 
        //$PLUGIN_HOOKS['itemtype']['trt16'] = ['Ticket','User'];

        // Garantir todas as permissões ao perfil super-admin (ID 4)
        $superadmin_id = 4;
        $plugin_rights = [
            'plugin_trt16_user_signup',
            'plugin_trt16_metrics_dashboard',
            // Adicione aqui todas as permissões customizadas do plugin
        ];
        foreach ($plugin_rights as $right) {
            $query = "REPLACE INTO glpi_profilerights (profiles_id, name, rights) VALUES ($superadmin_id, '$right', 31)";
            $DB->queryOrDie($query, $DB->error());
        }
    }
}

/**
 * Get the name and the version of the plugin
 * REQUIRED
 *
 * @return array
 */
function plugin_version_trt16()
{
    return [
        'name'           => 'TRT16',
        'version'        => PLUGIN_TRT16_VERSION,
        'author'         => 'TRT16',
        'license'        => '',
        'homepage'       => '',
        'requirements'   => [
            'glpi' => [
                'min' => PLUGIN_TRT16_MIN_GLPI_VERSION,
                'max' => PLUGIN_TRT16_MAX_GLPI_VERSION,
            ]
        ]
    ];
}

/**
 * Check pre-requisites before install
 * REQUIRED
 *
 * @return boolean
 */
function plugin_trt16_check_prerequisites()
{
    // Check GLPI version
    if (version_compare(GLPI_VERSION, PLUGIN_TRT16_MIN_GLPI_VERSION, 'lt')) {
        echo "Este plugin requer GLPI >= " . PLUGIN_TRT16_MIN_GLPI_VERSION;
        return false;
    }
    return true;
}

/**
 * Check configuration process
 *
 * @param boolean $verbose Whether to display message on failure. Defaults to false
 *
 * @return boolean
 */
function plugin_trt16_check_config($verbose = false)
{
    if ($verbose) {
        echo 'Parece OK';
    }
    return true;
}

if (!$DB->tableExists('glpi_plugin_trt16_consentimento_versao')) {
    $query = "CREATE TABLE glpi_plugin_trt16_consentimento_versao (
        id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        consentimento_texto TEXT,
        ativo CHAR(1)
    ) ENGINE=InnoDB";
    $DB->queryOrDie($query, $DB->error());
}

if (!$DB->tableExists('glpi_plugin_trt16_consentimento_lgpd')) {
    $query = "CREATE TABLE glpi_plugin_trt16_consentimento_lgpd (
        id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        data_hora DATETIME,
        consentimento_versao_id INT UNSIGNED,
        ip VARCHAR(50),
        glpi_users_id INT UNSIGNED,
        glpi_users_registro_id INT UNSIGNED
    ) ENGINE=InnoDB";
    $DB->queryOrDie($query, $DB->error());
}

