<?php

class PluginTRT16UserSignupMenu extends CommonGLPI {
    static $rightname = 'user';

    static function getMenuName() {
        return __('Criar Usuário Externo', 'trt16');
    }

    static function getMenuContent() {
        if (!Session::haveRight(static::$rightname, READ)) {
            return false;
        }

        $menu = [
            'title' => self::getMenuName(),
            'page'  => '/plugins/trt16/front/user_internal.form.php',
            'icon'  => 'ti ti-user-plus'
        ];

        $menu['options'] = [
            'signup' => [
                'title' => __('Criar Usuário Externo', 'trt16'),
                'page'  => '/plugins/trt16/front/user_internal.form.php',
                'icon'  => 'ti ti-user-plus',
                'links' => [
                    'search' => '/plugins/trt16/front/user_internal.form.php'
                ]
            ]
        ];

        return $menu;
    }
} 