<?php


ini_set('display_errors', 1);
use Glpi\Toolbox\Sanitizer;
/**
 * -------------------------------------------------------------------------
 * TRT16 plugin for GLPI
 * -------------------------------------------------------------------------
 */

//if (!defined('GLPI_ROOT')) {
   //die("Sorry. You can't access directly to this file");
//}

class PluginTRT16UserSignup extends CommonGLPI {
   //private $apiUrl = 'https://glpi-hml.trt16.jus.br/apirest.php/';
   private $apiUrl = 'https://central.trt16.jus.br/apirest.php/';
   // Configura o token de API do GLPI
   //private $apiToken = '9gxSwTS19F7GrFaeVXWM3qjMp9KtgEcEm4RdnMyM'; // Substitua pelo seu token da API
   private $apiToken = 'ePYgkMgaSw1i78hGctmtIRxV62dz6RxT5866QmJs'; // Substitua pelo seu token da API
   // Configura o token do usuário da API do GLPI
   //private $userToken = 'vLNj2kuaLmkVhyBmvRwREcNlOuyUVPTlEzSlq6j2'; // Substitua pelo seu token da API
   private $userToken = 'SaxbHsWmtQAbdCVIaWIFILrcqwvx7uRc9Vgz6OX8'; // Substitua pelo seu token da API
   //Token da sessão
   private $sessionToken = null;
   //Código do perfil externo
   //private $externalProfileId = 14;
   private $externalProfileId = 16;
   private $locationId = 87;
      
   function __construct() {   }

   /**
    * Limpa o CPF mantendo apenas números e garantindo 11 dígitos com zeros à esquerda
    * @param string $cpf CPF com ou sem formatação
    * @return string CPF limpo com 11 dígitos
    */
   private function cleanCPF($cpf) {
      // Remove tudo que não for número
      $cpf = preg_replace('/[^0-9]/', '', $cpf);
      
      // Garante que terá 11 dígitos preenchendo com zeros à esquerda se necessário
      return str_pad($cpf, 11, '0', STR_PAD_LEFT);
   }

   public function createUser($request) {
      global $DB;
      
      // Obtém os dados do corpo da solicitação
      $data = json_decode($request, true);
      if (!isset($data['input'])) {
         return "Entrada mal formatada!";
      }

      $user = $data['input'][0];
      if (!isset($user['name']) || !isset($user['email'])) {
         return 'Dados insuficientes';
      }

      try {
         // Limpa o CPF antes de salvar
         $cleanedCPF = $this->cleanCPF($user['name']);

         // Criar o usuário
         $newUser = new User();
         $userId = $newUser->add([
            'name'         => $cleanedCPF, // CPF limpo
            'firstname' => $user['firstname'],
            'realname'     => $user['realname'],
            'password'     => '',  // Será definido pelo usuário após receber o email
            'is_active'    => 1,
            'is_deleted'   => 0,
            'comment'      =>  $user['comment'],
            'registration_number' => $user['registration_number'],
            'phone' => $user['phone'],
            'entities_id'  => 0,   // Root entity
            'profiles_id'  => $this->externalProfileId,
            'locations_id' => $this->locationId,
            'usercategories_id' => $user['usercategories_id'],
            'authtype'     => 1,   // AUTH_DB_GLPI
            'password_forget_token'      => sha1(Toolbox::getRandomString(30)),
            'password_forget_token_date' => $_SESSION["glpi_currenttime"]
         ]);

         if (!$userId) {
            throw new \RuntimeException("Falha ao criar usuário");
         }

         // Adicionar email
         $userEmail = new UserEmail();
         if (!$userEmail->add([
            'users_id'   => $userId,
            'email'      => $user['email'],
            'is_default' => 1
         ])) {
            throw new \RuntimeException("Falha ao adicionar email");
         }

         // Adicionar perfil
         $profileUser = new Profile_User();
         if (!$profileUser->add([
            'users_id'    => $userId,
            'profiles_id' => $this->externalProfileId,
            'entities_id' => 0,
            'is_dynamic'  => 0
         ])) {
            throw new \RuntimeException("Falha ao adicionar perfil");
         }

         // Remover perfil self-service, se existir
         $this->removeSelfServiceProfileFromUser($userId);

         // Registrar consentimento LGPD
         $versao_ativa = $DB->request([
            'SELECT' => ['id','consentimento_texto'],
            'FROM'   => 'glpi_plugin_trt16_consentimento_versao',
            'WHERE'  => ['ativo' => 'S'],
            'LIMIT'  => 1
         ])->current();

         if ($versao_ativa) {
            $consentimento = [
               'data_hora' => $_SESSION["glpi_currenttime"],
               'consentimento_versao_id' => $versao_ativa['id'],
               'ip' => $_SERVER['REMOTE_ADDR'],
               'glpi_users_id' => $userId,
               'glpi_users_registro_id' => isset($user['glpi_users_registro_id']) ? $user['glpi_users_registro_id'] : Session::getLoginUserID()
            ];

            if (!$DB->insert('glpi_plugin_trt16_consentimento_lgpd', $consentimento)) {
               trigger_error("Falha ao registrar consentimento LGPD para usuário $userId: " . $DB->error(), E_USER_WARNING);
            }
            // Envio de e-mail com o texto do consentimento
            $consentimento_texto = $versao_ativa['consentimento_texto'] ?? '';
            
            if (!empty($consentimento_texto) && !empty($user['email'])) {
               // Log no navegador
               
               $subject = "Consentimento LGPD - Cadastro no GLPI";
               $body = "Olá, {$user['realname']}!\n\n"
                     . "Seu cadastro foi realizado com sucesso.\n\n"
                     . "Segue abaixo o texto do consentimento LGPD que você aceitou:\n\n"
                     . $consentimento_texto
                     . "\n\nCaso não tenha aceitado, entre em contato com nossa central de atendimento através do e-mail: cati@trt16.jus.br.\n\n"
                     . "\n\nAtenciosamente,\nCentral de Serviços do TRT da 16ª Região\nTel: Externo: (98)2109-9500";

                try {
                    /*Toolbox::sendMail(
                        [$user['email'] => $user['realname']], // Para
                        ['cati@trt16.jus.br' => 'Central de Serviços TRT16'], // De
                        $subject, // Assunto
                        $body, // Corpo
                        ['auto_submitted' => true]
                    );*/
                     
                     $mmail = new GLPIMailer();
                     $mmail->SetFrom('glpi@trt16.jus.br', Sanitizer::decodeHtmlSpecialChars('
Central de Serviços do TRT da 16ª Região'), false);
                     $mmail->AddAddress($user['email'], Sanitizer::decodeHtmlSpecialChars($user['realname']));
                     $mmail->Subject = $subject;
                     $mmail->Body    = $body;

                     $mmail->Send();
                        
                } catch (Exception $e) {
                    echo '<script>console.error("Erro ao enviar e-mail: ' . addslashes($e->getMessage()) . '");</script>';
                }
            }
         }

         // Enviar notificação
         NotificationEvent::raiseEvent('passwordforget', $newUser, ['entities_id' => 0]);
         QueuedNotification::forceSendFor($this->getType(), $userId);

         return ['id' => $userId];

      } catch (Exception $e) {
         // Se algo der errado, tenta limpar o usuário criado
         if (isset($userId)) {
            $newUser->delete(['id' => $userId], true);
         }
         \Glpi\Application\ErrorHandler::handleException($e);
         return "Erro: " . $e->getMessage();
      }
   }

   public function initSession() {
      $headers = array(
         'Content-Type: application/json',
         'App-Token: ' . $this->apiToken,
         'Authorization: user_token '. $this->userToken 
      );
   
      $endpoint = $this->apiUrl . "initSession";
      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $endpoint);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
      $json = curl_exec($ch);
      $resultado = json_decode($json,true);   
      curl_close ($ch);

      return isset($resultado['session_token']) ? $resultado['session_token'] : null;
   }

   public function addEmail($userId, $userEmail) {
      
      if (empty($userId) || empty($userEmail)) {
         echo 'Dados insuficientes';
         return false;
      }

      if(empty($this->sessionToken)){
         $this->sessionToken = $this->initSession();
      }
      
      if(!empty($this->sessionToken)){
         
         $headers = array(
            'Content-Type: application/json',
            'App-Token: ' . $this->apiToken,
            'Session-Token: '. $this->sessionToken 
         );
         
         $body = '{"input":{"users_id":' . $userId . ',"is_default":1,"is_dynamic":0,"email":"' . $userEmail . '"}}';
         $endpoint = $this->apiUrl . "/User/" . $userId . "/UserEmail/";
         $ch = curl_init();
         curl_setopt($ch, CURLOPT_URL, $endpoint);
         curl_setopt($ch, CURLOPT_POST, true);
         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
         curl_setopt($ch, CURLOPT_POSTFIELDS, $body); 
         $json = curl_exec($ch);
         
         $resultado = json_decode($json,true);
         if(isset($resultado[0]['id'])){
            return true;         
         }else{
            return false;
         }
         curl_close ($ch);
      }else{
         echo "Não foi possível iniciar a sessão com a API do GLPI!";
         return false;
      }
   }

   public function addProfile($userId) {
      
      if (empty($userId)) {
         echo 'Dados insuficientes';
         return false;
      }

      if(empty($this->sessionToken)){
         $this->sessionToken = $this->initSession();
      }
      
      if(!empty($this->sessionToken)){
         
         $headers = array(
            'Content-Type: application/json',
            'App-Token: ' . $this->apiToken,
            'Session-Token: '. $this->sessionToken 
         );
         //$externalProfileId = 14;
         $body = '{"input": [{ "users_id": '.$userId.', "profiles_id": '.$this->externalProfileId.', "entities_id" : 0 }]}';
         $endpoint = $this->apiUrl . "/Profile_User/";
         $ch = curl_init();
         curl_setopt($ch, CURLOPT_URL, $endpoint);
         curl_setopt($ch, CURLOPT_POST, true);
         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
         curl_setopt($ch, CURLOPT_POSTFIELDS, $body); 
         $json = curl_exec($ch);
         
         $resultado = json_decode($json,true);
         if(isset($resultado[0]['id'])){
            //se gerar automaticamente o selfservice, tem esse método para excluir
            //$this->removeSelfServiceProfileFromUser($userId);
            return true;         
         }else{
            return false;
         }
         curl_close ($ch);
      }else{
         echo "Não foi possível iniciar a sessão com a API do GLPI!";
         return false;
      }
   }

   public function getSelfServiceProfileId($userId) {
      $headers = array(
         'Content-Type: application/json',
         'App-Token: ' . $this->apiToken,
         'Authorization: user_token '. $this->userToken 
      );
   
      $endpoint = $this->apiUrl . "/search/Profile_User/?criteria[0][field]=4&criteria[0][searchtype]=equals&criteria[0][value]=1&criteria[1][field]=5&criteria[1][searchtype]=equals&criteria[1][value]=".$userId;
      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $endpoint);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
      $json = curl_exec($ch);
      $resultado = json_decode($json,true);   
      curl_close ($ch);

      return isset($resultado['data'][2]) ? $resultado['data'][2] : null;
   }

   public function removeSelfServiceProfileFromUser($userId) {
      
      if (empty($userId)) {
         echo 'Dados insuficientes';
         return false;
      }

      $userProfileId = $this->getSelfServiceProfileId($userId);
      if (empty($userProfileId)) {
         //echo 'o Usuário não tem perfil "self-service"';
         return true;
      }

      if(empty($this->sessionToken)){
         $this->sessionToken = $this->initSession();
      }
      
      if(!empty($this->sessionToken)){
         
         $headers = array(
            'Content-Type: application/json',
            'App-Token: ' . $this->apiToken,
            'Session-Token: '. $this->sessionToken 
         );
         
        // $body = '{"input": [{ "users_id": '.$userId.', "profiles_id": 8, "entities_id" : 0 }]}';
         $endpoint = $this->apiUrl . "/Profile_User/" . $userProfileId;
         $ch = curl_init();
         curl_setopt($ch, CURLOPT_URL, $endpoint);
         curl_setopt($ch, CURLOPT_DELETE, true);
         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
         //curl_setopt($ch, CURLOPT_POSTFIELDS, $body); 
         $json = curl_exec($ch);
         
         $resultado = json_decode($json,true);
         if(isset($resultado[0]['id'])){
            return true;         
         }else{
            return false;
         }
         curl_close ($ch);
      }else{
         echo "Não foi possível iniciar a sessão com a API do GLPI!";
         return false;
      }
   }

   

}