<?php
ini_set('display_errors', 1);
/**
 * -------------------------------------------------------------------------
 * TRT16 plugin for GLPI
 * -------------------------------------------------------------------------
 */

//if (!defined('GLPI_ROOT')) {
   //die("Sorry. You can't access directly to this file");
//}

include_once(PLUGIN_TRT16_DIR . "/tools/date-time-functions.php");
class PluginTRT16TicketMetrics{
    private $N1GroupId;

    private $ticketId;
    private $logGroup;
    private $solveGroup;
    private $solveDate;
    private $location;
    private $branch;

    private $N1ActiveDelay;
    private $N1UserPendingDelay;
    private $N2ActiveDelay;
    private $N2UserPendingDelay;
    private $N3ActiveDelay;
    private $N3UserPendingDelay;

    private $isReopened;
    private $isN1Eligile;
    private $ticketBelongsToBranch;


    
    function __construct($tickets_id, $ticketData, $branch) {
       global $N1GroupId;
       global $N2GroupId;

       $this->N1GroupId          =  $N1GroupId;
       $this->N2GroupId          =  $N2GroupId;

       $this->ticketId           =  $tickets_id;
       $this->logGroup           =  $ticketData['logGroup'];
       $this->solveGroup         =  $ticketData['solveGroup'];
       $this->solveDate          =  $ticketData['solveDate'];
       $this->N1ActiveDelay      =  $ticketData['N1ActiveDelay'];
       $this->N1UserPendingDelay =  $ticketData['N1UserPendingDelay'];
       $this->N2ActiveDelay      =  $ticketData['N2ActiveDelay'];
       $this->N2UserPendingDelay =  $ticketData['N2UserPendingDelay'];
       $this->N3ActiveDelay      =  $ticketData['N3ActiveDelay'];
       $this->N3UserPendingDelay =  $ticketData['N3UserPendingDelay'];
       $this->N1Eligible         =  $ticketData['N1Eligible'];
       $this->isReopened         =  $ticketData['isReopened'];
       $this->location           =  $ticketData['locationId'];
       $this->branch             =  $branch;
       $this->ticketBelongsToBranch = $this->isTicketFromBranch();
    }

    function getTicketsByDate($startDate, $endDate){
        global $DB;
        $it = $DB->request("select GT.id 
                            from glpi_tickets gt
                            where GT.SOLVEdate between '$startDate' and '$endDate'");

        return $it;
    }

    
    function isTicketFromBranch(){
        global $branchesLocations;
        $branch = $this->branch;
         
        if($branch == "SLZ"){
            //echo "<BR>" . $this->ticketId . ": Branch=$branch  --- Location=" . $this->location . "<BR>";
            $ITZLocations = $branchesLocations['ITZ'];
            $PRDLocations = $branchesLocations['PRD'];
            //echo "<BR>" . !in_array($this->location , $ITZLocations) . " and " .  !in_array($this->location , $PRDLocations) . "<BR>";
            return !in_array($this->location , $ITZLocations) && !in_array($this->location , $PRDLocations);
        }else{
            $branchLocations = $branchesLocations[$branch];
            return in_array($this->location , $branchLocations);
        }


    }
    
    function resolveN1Metrics(){
        $N1Metrics = array();
        $N1Metrics['n1.4'] = $this->n1_4();
        $N1Metrics['n1.5'] = $this->n1_5();
        $N1Metrics['n1.6'] = $this->n1_6();
        $N1Metrics['n1.7'] = $this->n1_7();
        $N1Metrics['n1.8'] = $this->n1_8();
        $N1Metrics['n1.9'] = $this->n1_9();
        $N1Metrics['n1.10'] = $this->n1_10();
        $N1Metrics['n1.11'] = $this->n1_11();
        $N1Metrics['n1.12'] = $this->n1_12();
        return $N1Metrics;
    }

    function resolveN2Metrics(){
        $N2Metrics = array();
        $N2Metrics['n2.1'] = $this->n2_1();
        $N2Metrics['n2.2'] = $this->n2_2();
        $N2Metrics['n2.3'] = $this->n2_3();
        $N2Metrics['n2.4'] = $this->n2_4();
        $N2Metrics['n2.5'] = $this->n2_5();
        $N2Metrics['n2.6'] = $this->n2_6();
        $N2Metrics['n2.7'] = $this->n2_7();
        $N2Metrics['n2.8'] = $this->n2_8();
        $N2Metrics['n2.9'] = $this->n2_9();
        $N2Metrics['n2.10'] = $this->n2_10();
        $N2Metrics['n2.11'] = $this->n2_11();
        $N2Metrics['n2.12'] = $this->n2_12();
        $N2Metrics['n2.13'] = $this->n2_13();
        $N2Metrics['n2.14'] = $this->n2_14();
        $N2Metrics['n2.15'] = $this->n2_15();
        return $N2Metrics;
        
    }

   
    //No mínimo 70% dos chamados solucionados pelo N1 devem ter sido solucionados nos primeiros 20 minutos após o registro.
    function n1_4(){
        //echo "<br>" . $this->ticketId . "<BR> i($this->solveGroup != $this->N1GroupId || !emp ty($this->N2ActiveDelay) || !em pty($this->N3ActiveDelay)){<br>";
        //Indicador não se aplica (retorna null): N1 não resolveu OU Chamado passou pelo N2 OU Chamado passou pelo N3
        if($this->solveGroup != $this->N1GroupId || !empty($this->N2ActiveDelay) || !empty($this->N3ActiveDelay)){
            return null;
        }    
       
        //atende se tempo de atendimento do N1 for menor ou igual a 20min
        return ($this->N1ActiveDelay <= 20 ? 1 : 0); 

    }

    //No mínimo 90% dos chamados solucionados pelo N1 devem ter sido solucionados nos primeiros 45 minutos após o registro.
    function n1_5(){
        //Indicador não se aplica (retorna null): N1 não resolveu OU Chamado passou pelo N2 OU Chamado passou pelo N3
        if($this->solveGroup != $this->N1GroupId || !empty($this->N2ActiveDelay) || !empty($this->N3ActiveDelay)){
            return null;
        }
        
        //atende se tempo de atendimento do N1 for menor ou igual a 20min
        return ($this->N1ActiveDelay <= 45 ? 1 : 0); 
    }

    //No mínimo 100% dos chamados solucionados pelo N1 devem ter sido solucionados nas primeiras 6 horas após o registro. 
    function n1_6(){
        //Indicador não se aplica (retorna null): N1 não resolveu OU Chamado passou pelo N2 OU Chamado passou pelo N3
        if($this->solveGroup != $this->N1GroupId || !empty($this->N2ActiveDelay) || !empty($this->N3ActiveDelay)){
            return null;
        }
        
        //atende se tempo de atendimento do N1 for menor ou igual a 20min
        return ($this->N1ActiveDelay <= (6 * 60) ? 1 : 0);
    }

    //O tempo médio de solução dos chamados solucionados pelo N1 de ver no máximo 20 minutos.
    function n1_7(){
        //Indicador não se aplica (retorna null): N1 não resolveu OU Chamado passou pelo N2 OU Chamado passou pelo N3
        if($this->solveGroup != $this->N1GroupId  || !empty($this->N2ActiveDelay) || !empty($this->N3ActiveDelay)){
            return null;
        }

        return $this->N1ActiveDelay;
    }

    //No mínimo 30% dos chamados elegíveis para o N1 devem ser solucionados pelo N1.
    function n1_8(){
        //Considera apenas chamados elegíveis
        if($this->N1Eligible != 1) return null;

        if($this->solveGroup == $this->N1GroupId){
            return 1;
        }else{
            return 0;
        }
    }

    //No máximo 5% dos chamados N1 podem ser reabertos.
    function n1_9(){
        //Indicador não se aplica (retorna null): N1 não resolveu OU Chamado passou pelo N2 OU Chamado passou pelo N3
        if(empty($this->N1ActiveDelay)){
            return null;
        }

        return ($this->isReopened ? 1 : 0); 
    }

    function n1_10(){}
    function n1_11(){}
    
    //No mínimo 95% dos chamados devem possuir somatório do tempo de parada de relógio inferior a 10 horas.
    function n1_12(){
       return ($this->N1UserPendingDelay > (10 * 60) ? 0 : 1);
    }

    //No mínimo 75% das tarefas terminadas pelo N2 devem ter sido terminadas nos primeiros 120 minutos após o seu recebimento. 
    function n2_1(){
        //echo "<BR>".$this->ticketId." é do polo: ".$this->ticketBelongsToBranch . " -->  solucionador: " . $this->solveGroup;
        //Se não for do polo em questão, o indicador não se aplica
        if(!$this->ticketBelongsToBranch){
            return null;
        }        
        
        //Indicador não se aplica (retorna null): N2 não resolveu
        //if($this->solveGroup != $this->N2GroupId){
        if(empty($this->N2ActiveDelay)){
            return null;
        }
        
        //atende se tempo de atendimento do N1 for menor ou igual a 20min
        return ($this->N2ActiveDelay <= 120 ? 1 : 0); 
    }
    
    //No mínimo 100% das tarefas terminadas pelo N2 devem ter sido terminadas  nas primeiras 8 horas após o seu recebimento. 
    function n2_2(){
        //Se não for do polo em questão, o indicador não se aplica
        if(!$this->ticketBelongsToBranch){
            return null;
        }
        //Indicador não se aplica (retorna null): N2 não resolveu
        //if($this->solveGroup != $this->N2GroupId){
        if(empty($this->N2ActiveDelay)){
            return null;
        }
        
        //atende se tempo de atendimento do N1 for menor ou igual a 20min
        return ($this->N2ActiveDelay <= (8*60) ? 1 : 0); 
    }

    //O tempo médio de solução dos chamados N2O deve ser no máximo 120 minutos.
    function n2_3(){
        //Se não for do polo em questão, o indicador não se aplica
        if(!$this->ticketBelongsToBranch){
            return null;
        }   
        //Indicador não se aplica (retorna null): N2 não resolveu 
        //if($this->solveGroup != $this->N2GroupId){
        if(empty($this->N2ActiveDelay)){
            return null;
        }

        return $this->N2ActiveDelay;
    }

    //No mínimo 80% dos chamados resolvidos pelo N2 não devem ter escalação para o N3 
    function n2_4(){
        //Se não for do polo em questão, o indicador não se aplica
        if(!$this->ticketBelongsToBranch){
            return null;
        }
        //Indicador não se aplica (retorna null): N2 não resolveu
        //if($this->solveGroup != $this->N2GroupId){
        if(empty($this->N2ActiveDelay)){
            return null;
        }

        //temporariamente desabilitado, por isso retorna null enquanto estiver desabiilitado
        return null;

        return ($this->N3ActiveDelay > 0 ? 0 : 1);
    }

    //O tempo médio que o N2 escalona para o N3 deve ser no máximo 60 minutos.
    function n2_5(){}

    //No máximo 5% dos chamados resolvidos pelo N2 podem ser reabertos. 
    function n2_6(){
        //Se não for do polo em questão, o indicador não se aplica
        if(!$this->ticketBelongsToBranch){
            return null;
        }
        if($this->ticketId == 13861){ return null;}
        //Indicador não se aplica (retorna null): N2 não resolveu
        //if($this->solveGroup != $this->N2GroupId){
      
        //if($this->solveGroup != $this->N2GroupId){
            //return null;
        //}

        if(empty($this->N2ActiveDelay)){
            return null;
        }



        return ($this->isReopened ? 1 : 0); 
    }

    //No máximo 10% dos chamados N2O podem ser escalados equivocadamente para outros serviços de atendimento. 
    function n2_7(){}

    //No mínimo 65% das tarefas classificadas como urgente terminadas pelo N2 devem ter sido terminadas nos primeiros 15 minutos após o seu recebimento.  
    function n2_8(){}
    function n2_9(){}
    function n2_10(){}
    function n2_11(){}
    function n2_12(){}
    function n2_13(){}
    function n2_14(){}
    function n2_15(){}
}