<?php
ini_set('display_errors', 1);
/**
 * -------------------------------------------------------------------------
 * TRT16 plugin for GLPI
 * -------------------------------------------------------------------------
 */

//$path = Plugin::getPhpDir("trt16");
include_once(PLUGIN_TRT16_DIR . "/tools/date-time-functions.php");

//if (!defined('GLPI_ROOT')) {
   //die("Sorry. You can't access directly to this file");
//}

class PluginTRT16TicketHistory extends CommonGLPI {
    
    //const HISTORY_LIMIT = 4;
   function __construct() {}

   static function getFullHistory($tickets_id) {
      global $DB;
      $it = $DB->request("SELECT items_id,itemtype_link, date_mod, old_value, new_value, user_name 
                              FROM glpi_logs
                              WHERE itemtype = 'Ticket' 
                              AND (itemtype_link IN ('User','Group','PendingReason','ITILSolution') OR (old_value IN (2,4,5) AND new_value in (2,4)))
                              AND new_value <> ''
                              AND items_id = '".$tickets_id."'
                              ORDER BY date_mod");
      return $it;
   }

   static function showList($tickets_id){
        $history = self::getFullHistory($tickets_id);
        echo "<table  class=\"search-results table card-table table-hover table-striped\"><thead>";
        echo "<tr><th>Data</th>";
        echo "<th>Evento</th>";
        //echo "<th>Ator</th>";
        echo "<th>Valor</th>";
        echo "<th>Usuário</th>";
        echo "<th>Tempo</th></tr></thead>";
        $dataAnterior = "";
        $acaoRegistro = true;
        foreach ($history as $key => $line) {
            $date = $line['date_mod'];
            $action = self::getActionLabel($line,$acaoRegistro);
            echo "<tr><td>".$date."</td>";
            echo "<td>".$action."</td>";
            //echo "<td>".$line['old_value']."</td>";
            echo "<td>".$line['new_value']."</td>";
            echo "<td>".$line['user_name']."</td>";
            if($dataAnterior == ""){
               $dataAnterior = $date;
               echo "<td>0</td></tr>";
            }else{
               $dateTime1 = DateTime::createFromFormat('Y-m-d H:i:s', $dataAnterior);
               $dateTime2 = DateTime::createFromFormat('Y-m-d H:i:s', $date);
               $partialGroupDelay = resolveDelay($dateTime1,$dateTime2);
               $dataAnterior = $date;
               echo "<td>".$partialGroupDelay."</td></tr>";
            }
            $acaoRegistro = false;
        }
        echo "</table>";
       
   }

   static function getActionLabel($action,$isFirstAction){
      if($action['itemtype_link'] == "User"){
         return $isFirstAction ? "Registro" : "Atribuição a técnico";
      }
      if($action['itemtype_link'] == "Group"){
         return "Atribuição a grupo";
      }
      if($action['itemtype_link'] == "PendingReason"){
         return "Parada de Relógio";
      }
      if($action['itemtype_link'] == "PendingReason"){
         return "Parada de Relógio";
      }
      if($action['itemtype_link'] == "ITILSolution"){
         return "Solução";
      }
      if($action['new_value'] == "4"){
         return "Parada de relógio";
      }
      if($action['old_value'] == "4" ){
         return "Retorno de relógio";
      }
      return $action['itemtype_link'];
   }
}