<?php
ini_set('display_errors', 1);
/**
 * -------------------------------------------------------------------------
 * TRT16 plugin for GLPI
 * -------------------------------------------------------------------------
 */

//if (!defined('GLPI_ROOT')) {
   //die("Sorry. You can't access directly to this file");
//}
include_once(GLPI_ROOT . "/inc/includes.php");
//$path = Plugin::getPhpDir("trt16");
include_once(PLUGIN_TRT16_DIR . "/tools/date-time-functions.php");
class PluginTRT16TicketDelays{
    private $ticketId;
    private $ticketDateLog;
    private $ticketGroupLog;
    private $ticketGroupSolve;
    private $ticketUserLog;
    private $ticketActions;
    private $ticketGroups = array();
    private $totalGroupsDelay;
    private $verbose;

    function __construct($tickets_id,$verbose = false) {
        $this->ticketId = $tickets_id;
        $this->verbose = $verbose;
        $this->ticketActions = $this->getTicketActions();
        $this->initializeTotalGroupsDelay();
    }

    function getTicketActions(){
        global $DB;
        $it = $DB->request("SELECT items_id,itemtype_link, date_mod, old_value, new_value, user_name 
                    FROM `glpi_logs`
                    WHERE `itemtype` = 'Ticket' 
                    AND (itemtype_link IN ('User','Group','PendingReason','ITILSolution') OR (old_value IN (2,4,5) AND new_value in (2,4)))
                    AND new_value <> ''
                    AND `items_id` = '".$this->ticketId."'
                    ORDER BY date_mod");

        //echo "<table border=1>";
        $arrayResult = array();
        $this->ticketGroups = array();
        $indice = 0;
        //$ticketGroups = array();

        
        foreach ($it as $key => $line) {
            $arrayResult[$indice] = array(
                                        'actionType' => $line['itemtype_link'],
                                        'actionDate' => $line['date_mod'],
                                        'actionOldValue' => $line['old_value'],
                                        'actionNewValue' => $line['new_value'],
                                        'userName' => $line['user_name']
            );
            $groupId = $this->getIdFromString($line['new_value']);
            //Adiciona o grupo à lista de grupos do chamado
            if( !in_array($groupId,$this->ticketGroups) && $line['itemtype_link'] == "Group" ){
                array_push($this->ticketGroups,$groupId);
                //echo "<br>Ticket ". $this->ticketId."<br>##############<br>".$groupId."<br><br>##############<br>";
            }

            //echo "<tr> <td>".$arrayResult[$indice]['actionType']."</td> <td>".$arrayResult[$indice]['actionDate']."</td> <td>".$arrayResult[$indice]['actionOldValue']."</td> <td>".$arrayResult[$indice]['actionNewValue']."</td> </tr>";
            $indice++;

        }
        
        return $arrayResult;
    }

    function initializeTotalGroupsDelay(){
        $this->totalGroupsDelay = array();
        $this->totalGroupsDelay[0] = array();
        $this->totalGroupsDelay[0]['activeDelay'] = 0; // tempo atendimento
        $this->totalGroupsDelay[0]['pendingUserDelay'] = 0; // tempo Parado por pendencia de usuário
        $this->totalGroupsDelay[0]['pendingTeamDelay'] = 0; // tempo Parado por pendência de equipe interna
        foreach($this->ticketGroups as $group){
            $this->totalGroupsDelay[$group] = array();
            $this->totalGroupsDelay[$group]['activeDelay'] = 0; // tempo atendimento
            $this->totalGroupsDelay[$group]['pendingUserDelay'] = 0; // tempo Parado por pendencia de usuário
            $this->totalGroupsDelay[$group]['pendingTeamDelay'] = 0; // tempo Parado por pendência de equipe interna
        }
        //print_r($this->totalGroupsDelay);
    }

    function getIdFromString($string){
        return str_replace(")","",substr($string,strrpos($string,"(")+1));
    }

    public function resolveGroupsDelays(){
        global $DB;
        //Consulta no banco do GLPI as ações do chamado
        //$arrayResult = $this->getTicketActions($tickets_id);
        $arrayTemp = $this->ticketActions;
        $arrayResult = array();
        //só passa em ações do tipo User uma vez para consultar o grupo que registrou
        $alreadyPassUser = false;
        $index = 0;
        for($i = 0 ; $i < count($arrayTemp) ; $i++){
            if($arrayTemp[$i]['actionType'] == "User"){
                if(!$alreadyPassUser){
                    //só mantem a linha de log do tipo User, se for a primeira ação do log
                    if($i == 0){
                        $arrayResult[$index] = $arrayTemp[$i];
                        $index++;
                    }
                    $alreadyPassUser = true;
                }
            }else{
                $arrayResult[$index] = $arrayTemp[$i];
                $index++;
            }
        }
        //if($this->verbose) echo "<br>Chamado = " . $this->ticketId ;
        foreach($arrayResult as $item){
            $startActionType       = $item['actionType'];
            $startActionDate       = $item['actionDate'];
            $startActionOldValue   = $item['actionOldValue'];
            $startActionNewValue   = $item['actionNewValue'];
            
            //echo $startActionType . " - " . $startActionDate . " - " . $startActionOldValue . " - " . $startActionNewValue . "<BR>";
        }
        
        $partialGroupDelay = 0;
        $group = '0';
        $groupId = null; 
        $previousGroup = $group;
        $pendingReason = "";
        $paused = false;
        //if($this->verbose) echo "<table border=2>";
        //Para cada par de ações, calcula a diferença de tempos
        for($i = 0 ; $i < count($arrayResult) - 1 ; $i++){
            
            if($group != $previousGroup){$partialGroupDelay = 0;}

            $startActionType       = $arrayResult[$i]['actionType'];
            $startActionDate       = $arrayResult[$i]['actionDate'];
            $startActionOldValue   = $arrayResult[$i]['actionOldValue'];
            $startActionNewValue   = $arrayResult[$i]['actionNewValue'];
            if($startActionType == "Group") $group = $this->getIdFromString($startActionNewValue);

            $endActionType       = $arrayResult[$i+1]['actionType'];
            $endActionDate       = $arrayResult[$i+1]['actionDate'];
            $endActionOldValue   = $arrayResult[$i+1]['actionOldValue'];
            $endActionNewValue   = $arrayResult[$i+1]['actionNewValue'];
            //if($endActionType == "Group") $startActionGroup = $startActionNewValue;

            $dateTime1 = DateTime::createFromFormat('Y-m-d H:i:s', $startActionDate);
            $dateTime2 = DateTime::createFromFormat('Y-m-d H:i:s', $endActionDate);
            $partialGroupDelay = resolveDelay($dateTime1,$dateTime2);
            //echo "<br><br>......................partialGroupDelay = r esolveDelay( $startActionDate ,$endActionDate)............................<br><br>";
            
            if(!$paused){
                if($i == 0 ){//se é a primeira linha dos logs, pega o id do grupo que registrou
                    $this->ticketUserLog = $this->getIdFromString($arrayResult[$i]['userName']);
                    $itGroup = $DB->request("SELECT groups_id  
                                                FROM `glpi_users`
                                                WHERE id = '".$this->ticketUserLog."'" );

                    if(is_numeric($itGroup->current()['groups_id'])){                
                        $this->ticketGroupLog = $itGroup->current()['groups_id'];
                    }else{
                        $this->ticketGroupLog = 0;
                    }
                }

            
                    
                

                if($endActionType == "ITILSolution"){
                    
                    $ticketSolution = $this->getIdFromString($endActionNewValue);

                    $itGroupSolve = $DB->request("SELECT gu.groups_id 
                                                FROM glpi_itilsolutions gi 
                                                INNER JOIN glpi_users gu ON (gi.users_id = gu.id)
                                                WHERE gi.id = '".$ticketSolution."'" );
                    echo "grupo: "; print_r($itGroupSolve->current());
                    if(isset($itGroupSolve->current()['groups_id'])){
                        $groupId = $itGroupSolve->current()['groups_id'];
                    }else{
                        $groupId = 0;
                    }
                    //echo "<div>Grupo Resolvedor: $groupId </div><br>";
                    $this->ticketGroupSolve = $groupId;

                    if($startActionType == "User"){
                        //echo "<div>Em atendimento no grupo $groupId: $partialGroupDelay </div><br>";
                        //se a linha de total para o grupo em questão ainda não estiver definida, inicializa com 0
                        //isso acontece quando o chamado é fechado logo após o registro e não tem ações intermediárias do tipo GROUP
                        if(!isset($this->totalGroupsDelay[$groupId]['activeDelay'])) $this->totalGroupsDelay[$groupId]['activeDelay'] = 0;
                        $this->totalGroupsDelay[$groupId]['activeDelay'] += $partialGroupDelay;
                    }
                }

        
           
                //echo "<tr> <td>".$arrayResult[$i]['actionType']."</td> <td>".$arrayResult[$i]['actionDate']."</td> <td>".$arrayResult[$i]['actionOldValue']."</td> <td>".$arrayResult[$i]['actionNewValue']."</td> </tr>";
                //identifica se trata-se de um tempo de chamado parado
                if($startActionType == "PendingReason"){
                    //Verifica se a parada de relógio é em virtude de uma pendência do usuário
                    if($this->getIdFromString($startActionNewValue) == 2){
                        //echo "<div>Pendencia do usuário no grupo $group: $partialGroupDelay</div> <br>";
                        $this->totalGroupsDelay[$group]['pendingUserDelay'] += $partialGroupDelay;
                        $pendingReason = 'pendingUserDelay';
                        if($endActionNewValue != "2") $paused = true; else $paused = false; 
                    //Se não for pendência de usuário agrupa como outro tipo de tempo parado  
                    }else{
                        //echo "<div>Outra Pendencia no grupo $group: $partialGroupDelay </div><br>";
                        $this->totalGroupsDelay[$group]['pendingTeamDelay'] += $partialGroupDelay; 
                        $pendingReason = 'pendingTeamDelay';
                        if($endActionNewValue != "2") $paused = true; else $paused = false;
                    }
                    
                }elseif($startActionOldValue == "2" && $startActionNewValue == "4"){
                    $this->totalGroupsDelay[$group]['pendingTeamDelay'] += $partialGroupDelay;
                    $pendingReason = 'pendingTeamDelay';
                    if($endActionNewValue != "2") $paused = true; else $paused = false;
                }elseif($startActionType != "User" && $startActionType != "ITILSolution"){
                        
                        //descobre o tempo de primeira atribuição do N2 para o N3
                    // if($group == '2')
                        
                        //soma o tempo total de atendimento por grupo
                        //echo "<div>Em atendimento no grupo $group: $partialGroupDelay </div><br>";
                        $this->totalGroupsDelay[$group]['activeDelay'] += $partialGroupDelay;
                }
            }else{
                $this->totalGroupsDelay[$group][$pendingReason] += $partialGroupDelay;
                if($endActionType == "ITILSolution"){
                    
                    $ticketSolution = $this->getIdFromString($endActionNewValue);

                    $itGroupSolve = $DB->request("SELECT gu.groups_id 
                                                FROM glpi_itilsolutions gi 
                                                INNER JOIN glpi_users gu ON (gi.users_id = gu.id)
                                                WHERE gi.id = '".$ticketSolution."'" );
                    echo "grupo: "; print_r($itGroupSolve->current());
                    if(isset($itGroupSolve->current()['groups_id'])){
                        $groupId = $itGroupSolve->current()['groups_id'];
                    }else{
                        $groupId = 0;
                    }
                    //echo "<div>Grupo Resolvedor: $groupId </div><br>";
                    $this->ticketGroupSolve = $groupId;

                    if($startActionType == "User"){
                        //echo "<div>Em atendimento no grupo $groupId: $partialGroupDelay </div><br>";
                        //se a linha de total para o grupo em questão ainda não estiver definida, inicializa com 0
                        //isso acontece quando o chamado é fechado logo após o registro e não tem ações intermediárias do tipo GROUP
                        if(!isset($this->totalGroupsDelay[$groupId]['activeDelay'])) $this->totalGroupsDelay[$groupId]['activeDelay'] = 0;
                        $this->totalGroupsDelay[$groupId]['activeDelay'] += $partialGroupDelay;
                    }
                }
            }    
        }   
        //echo "<tr> <td>".$arrayResult[$i]['actionType']."</td> <td>".$arrayResult[$i]['actionDate']."</td> <td>".$arrayResult[$i]['actionOldValue']."</td> <td>".$arrayResult[$i]['actionNewValue']."</td> </tr>";
       // echo "</table>";
        
    }

    function saveGroupDelays($group_id, $active_delay, $user_pending_delay, $team_pending_delay,$log_group,$solve_group){
        global $DB;
        $solve_group = empty($solve_group) ? "NULL" : $solve_group;  
        $log_group = empty($log_group) ? "NULL" : $log_group;  
        $DB->queryOrDie(
            "REPLACE glpi_plugin_trt16_ticket_history 
            (tickets_id,groups_id, active_delay, user_pending_delay,team_pending_delay,log_group,solve_group) 
            VALUES (
                '".$this->ticketId."',
                '".$group_id."',
                '".$active_delay."',
                '".$user_pending_delay."',
                '".$team_pending_delay."',
                ".$log_group.",           
                ".$solve_group."           
            )",
            $DB->error()
         );
    }

    function saveTicketDelays(){
        //print_r($this->totalGroupsDelay);
        foreach($this->totalGroupsDelay as $group => $groupDelays){
            
            $groupId = $group;
            $activeDelay        = isset($groupDelays['activeDelay']) ? $groupDelays['activeDelay'] : 0;
            $pendingUserDelay   = isset($groupDelays['pendingUserDelay']) ? $groupDelays['pendingUserDelay'] : 0;
            $pendingTeamDelay   = isset($groupDelays['pendingTeamDelay']) ? $groupDelays['pendingTeamDelay'] : 0;
            
                       
            $this->saveGroupDelays( $groupId, 
                                    $activeDelay,
                                    $pendingUserDelay,
                                    $pendingTeamDelay,
                                    $this->ticketGroupLog,
                                    $this->ticketGroupSolve
            );
        }
    }

    function updateTicketsDelay($startDate, $endDate){
        global $DB;
       
        
        $it = $DB->request("SELECT distinct 
                            t.id 
                            FROM glpi_tickets t  
                            WHERE t.solvedate between '$startDate' and '$endDate' 
        ");
        $ticketCount = 0;
        foreach ($it as $key => $line) {
            $this->ticketId = $line['id'];
            if($this->verbose) echo "<br>Chamado: " . $line['id'] ;
            $ticketDateLog = null;
            $ticketGroupLog = null;
            $ticketGroupSolve = null;
            $ticketUserLog = null;
            $ticketActions = null;
            $ticketGroups = array();
            $totalGroupsDelay;
            $this->ticketActions = $this->getTicketActions();
            $this->initializeTotalGroupsDelay();
            $this->resolveGroupsDelays();
            $this->saveTicketDelays();
            $ticketCount++;
        }
        if($this->verbose) echo "<hr>Total de Chamados: " . $ticketCount . "<br>";
        
        return $it;
    }

    function resetGLPIGroupsDelays(){
        global $DB;
        $itGroups = $DB->request("SELECT id FROM glpi_groups ");
        foreach ($itGroups as $key => $line) {
            $group = $line['id'];
            $this->totalGroupsDelay[$group] = array();
            $this->totalGroupsDelay[$group]['activeDelay'] = 0; // tempo atendimento
            $this->totalGroupsDelay[$group]['pendingUserDelay'] = 0; // tempo Parado por pendencia de usuário
            $this->totalGroupsDelay[$group]['pendingTeamDelay'] = 0; // tempo Parado por pendência de equipe interna
        }

    }

    function exculpateGroupDelays($group_id, $active_delay,$message, $user_pending_delay = null, $team_pending_delay = null){
        global $DB;
        $solve_group = empty($solve_group) ? "NULL" : $solve_group;  
        $log_group = empty($log_group) ? "NULL" : $log_group;  
        $updateActiveDelay = "";
        $updateUserPendingDelay = "";
        $updateTeamPendingDelay = "";
        
        if(!empty($active_delay) || $active_delay === 0 ){
            $updateActiveDelay = ", active_delay = $active_delay ";
        }
        if(!empty($user_pending_delay) || $user_pending_delay === 0 ){
            $updateUserPendingDelay = ", user_pending_delay = $user_pending_delay ";
        }
        if(!empty($team_pending_delay) || $team_pending_delay === 0 ){
            $updateTeamPendingDelay = ", team_pending_delay = $team_pending_delay ";
        }
               
        $DB->queryOrDie(
            "UPDATE glpi_plugin_trt16_ticket_history 
            SET
            /*justification = concat('$message [Valor Anterior = ' , active_delay , ']'),*/
            justification_date = NOW() 
            $updateActiveDelay
            $updateUserPendingDelay
            $updateTeamPendingDelay
            WHERE 
            tickets_id = '".$this->ticketId."' 
            AND groups_id = '".$group_id."'
            ",
            $DB->error()
         );
         
    }

    

}