<?php


class PluginTrt16TicketClone  extends CommonDBTM{
    /**
     * Clona um chamado, suas tarefas e acompanhamentos
     * @param int $ticket_id
     * @param int $user_id
     * @return array
     */
    static function cloneTicketWithTasksAndFollowups($ticket_id, $user_id) {
        global $DB;

        
        // 1. Buscar dados do chamado original
        $ticket_row = $DB->request(["FROM" => "glpi_tickets", "WHERE" => ["id" => $ticket_id]])->current();
        if (!$ticket_row) {
            return ['error' => 'Chamado não encontrado'];
        }

        // 2. Preparar dados do novo chamado
        $fields_to_copy = $ticket_row;
        unset($fields_to_copy['id'], $fields_to_copy['date'], $fields_to_copy['date_mod'], $fields_to_copy['date_creation']);
        $fields_to_copy['status'] = 1; // INCOMING
        $fields_to_copy['users_id_recipient'] = $user_id;
        $fields_to_copy['date'] = $fields_to_copy['date_creation'] = $fields_to_copy['date_mod'] = date('Y-m-d H:i:s');

        // 3. Inserir novo chamado
        $DB->insert('glpi_tickets', $fields_to_copy);
        $new_ticket_id = $DB->insertId();
        if (!$new_ticket_id) {
            return ['error' => 'Erro ao criar novo chamado'];
        }

        // 4. Clonar usuários do chamado (demandante e técnicos)
        $users = $DB->request(["FROM" => "glpi_tickets_users", "WHERE" => ["tickets_id" => $ticket_id]]);
        foreach ($users as $u) {
            $user_data = $u;
            unset($user_data['id'], $user_data['tickets_id']);
            $user_data['tickets_id'] = $new_ticket_id;
            $DB->insert('glpi_tickets_users', $user_data);
        }

        // 5. Clonar grupos do chamado
        $groups = $DB->request(["FROM" => "glpi_groups_tickets", "WHERE" => ["tickets_id" => $ticket_id]]);
        foreach ($groups as $g) {
            $group_data = $g;
            unset($group_data['id'], $group_data['tickets_id']);
            $group_data['tickets_id'] = $new_ticket_id;
            $DB->insert('glpi_groups_tickets', $group_data);
        }

        // 6. Clonar tarefas
        $tasks = $DB->request(["FROM" => "glpi_tickettasks", "WHERE" => ["tickets_id" => $ticket_id]]);
        $tasks_array = iterator_to_array($tasks);
        foreach ($tasks_array as $t) {
            $task_data = $t;
            
            unset($task_data['id'], $task_data['tickets_id'], $task_data['date'], $task_data['date_mod'],$task_data['state'],$task_data['date_creation']);
            $task_data['tickets_id'] = $new_ticket_id;
            $task_data['date'] = $task_data['date_mod'] = $task_data['date_creation'] = date('Y-m-d H:i:s');
            $task_data['state'] = 1; // 1 = A Fazer
            if (isset($task_data['uuid'])) {
                $task_data['uuid'] = md5(uniqid(rand(), true));
            }
            
            $insert_result = $DB->insert('glpi_tickettasks', $task_data);
            if (!$insert_result) {
                error_log('Erro ao inserir tarefa: ' . $DB->error() . ' Dados: ' . print_r($task_data, true));
            }
        }

        // 7. Clonar acompanhamentos
        $followups = $DB->request(["FROM" => "glpi_itilfollowups", "WHERE" => ["items_id" => $ticket_id, "itemtype" => "Ticket"]]);
        
        
        foreach ($followups as $f) {
            $followup_data = $f;
            unset($followup_data['id'], $followup_data['items_id'], $followup_data['date'], $followup_data['date_mod'], $followup_data['state'], $followup_data['date_creation']);
            $followup_data['items_id'] = $new_ticket_id;
            $followup_data['itemtype'] = 'Ticket';
            $followup_data['date'] = $followup_data['date_mod'] = $followup_data['date_creation'] = date('Y-m-d H:i:s');
            print_r($followup_data);
            $insert_result = $DB->insert('glpi_itilfollowups', $followup_data);
            if (!$insert_result) {
                error_log('Erro ao inserir acompanhamento: ' . $DB->error() . ' Dados: ' . print_r($followup_data, true));
            }
        }

        return ['success' => true, 'new_ticket_id' => $new_ticket_id];
    }

    function getTabNameForItem(CommonGLPI $item, $withtemplate = 0) {
        global $DB;
        $ticket_id = is_object($item) ? $item->getID() : (isset($item['id']) ? $item['id'] : 0);
        
        echo "<script>console.log('Aba clonar TRT16 chamado: $ticket_id');</script>";
        return __('Clonar TRT16', 'trt16');
     }

    static function displayTabContentForItem(CommonGLPI $ticket, $tabnum = 1, $withtemplate = 0)  {
        $ticket_id = is_object($ticket) ? $ticket->getID() : (isset($ticket['id']) ? $ticket['id'] : 0);

        if (!$ticket_id) {
            echo "<div class='center b'>ID do chamado não informado.</div>";
            return;
        }

        global $CFG_GLPI;
        $clone_url = $CFG_GLPI['root_doc'] . "/plugins/trt16/front/ticket_clone.action.php?id=$ticket_id";
        echo "<a href='$clone_url' class='btn btn-primary' onclick=\"return confirm('Tem certeza que deseja clonar este chamado, suas tarefas e acompanhamentos?');\">Clonar Chamado TRT16</a>";
    }

    
} 