<?php

if (!defined('GLPI_ROOT')) {
   die("Sorry. You can't access this file directly");
}

class PluginTrt16Satisfaction extends CommonDBTM {

   function getTabNameForItem(CommonGLPI $item, $withtemplate = 0) {
      global $DB;
      $ticket_id = is_object($item) ? $item->getID() : (isset($item['id']) ? $item['id'] : 0);
      $count = 0;
      $last_rating = null;
      if ($ticket_id) {
          // Conta o total de avaliações
          $result = $DB->query("SELECT COUNT(*) AS total FROM glpi_plugin_trt16_satisfactions WHERE tickets_id = $ticket_id");
          if ($result && $DB->numrows($result)) {
              if (method_exists($DB, 'fetch_assoc')) {
                  $row = $DB->fetch_assoc($result);
              } else {
                  $row = mysqli_fetch_assoc($result);
              }
              $count = (int)$row['total'];
          }
          // Busca a última avaliação (mais recente)
          $result_last = $DB->query("SELECT rating FROM glpi_plugin_trt16_satisfactions WHERE tickets_id = $ticket_id ORDER BY date_answered DESC, id DESC LIMIT 1");
          if ($result_last && $DB->numrows($result_last)) {
              if (method_exists($DB, 'fetch_assoc')) {
                  $row_last = $DB->fetch_assoc($result_last);
              } else {
                  $row_last = mysqli_fetch_assoc($result_last);
              }
              $last_rating = isset($row_last['rating']) ? (int)$row_last['rating'] : null;
          }
      }
      // Define a classe do badge
      $badge_class = 'badge';
      if ($last_rating !== null && $last_rating <= 3) {
          $badge_class .= ' bg-danger';
      }
      echo "<script>console.log('Aba TRT16 chamado: $ticket_id');</script>";
      return __('Satisfação TRT16', 'trt16') . ' <span class="' . $badge_class . '">' . $count . '</span>';
   }

   static function canCreate() { return true; }
   static function canView()   { return true; }
   static function canUpdate() { return true; }
   static function canDelete() { return true; }

   static function displayTabContentForItem(CommonGLPI $ticket, $tabnum = 1, $withtemplate = 0)  {
      global $DB, $CFG_GLPI;

      $ticket_id = is_object($ticket) ? $ticket->getID() : $ticket['id'];
      $userid = Session::getLoginUserID();

      // Processa POST para salvar tratativa ou nova avaliação OU atualizar central_feedback
      if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['plugin_trt16_satisfaction'])) {
         $input = [
            'tickets_id' => $ticket_id,
            'user_id' => $userid,
            'rating' => intval($_POST['rating']),
            'comment' => $_POST['comment'],
            'central_feedback' => $_POST['central_feedback'],
            'date_answered' => date('Y-m-d H:i:s')
         ];
         $input['possui_feedback_central'] = (!empty(trim($_POST['central_feedback']))) ? 1 : 0;
         if (!empty($_POST['id'])) {
            $input['id'] = intval($_POST['id']);
            $satisfaction = new self();
            $satisfaction->update($input);
         } else {
            $satisfaction = new self();
            $satisfaction->add($input);
         }
         Html::redirect($_SERVER['REQUEST_URI']);
      } else if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_central_feedback'])) {
         $id = intval($_POST['satisfaction_id']);
         $central_feedback = $_POST['central_feedback_edit'] ?? '';
         $possui_feedback_central = (!empty(trim($central_feedback))) ? 1 : 0;
         $satisfaction = new self();
         $satisfaction->update([
            'id' => $id,
            'central_feedback' => $central_feedback,
            'possui_feedback_central' => $possui_feedback_central
         ]);
         Html::redirect($_SERVER['REQUEST_URI']);
      }

      // Lista avaliações existentes
      $iterator = $DB->request([
         'FROM' => self::getTable(),
         'WHERE' => ['tickets_id' => $ticket_id],
         'ORDER' => ['date_answered']
      ]);

      if (count($iterator)) {
         echo "<h3>".__('Respostas de Satisfação', 'trt16')."</h3>";
         echo "<table class='tab_cadre' width='100%'>";
         echo "<tr>
                  <th>Data da resposta</th>
                  <th>Nota</th>
                  <th>Comentário</th>
                  <th>Tratativa Central</th>
               </tr>";
         $row_index = 0;
         $rateit_js = "";
         foreach ($iterator as $row) {
             if (!is_array($row)) continue;
             // Formatar data no padrão brasileiro
             $data_br = '';
             if (!empty($row['date_answered'])) {
                 $dt = DateTime::createFromFormat('Y-m-d H:i:s', $row['date_answered']);
                 if ($dt) {
                     $data_br = $dt->format('d/m/Y H:i');
                 } else {
                     $data_br = $row['date_answered'];
                 }
             }
             $unique_id = 'cf_' . intval($row['id']) . '_' . $row_index;
             echo "<tr>";
             echo "<td>" . htmlspecialchars($data_br) . "</td>";
             echo "<td>";
             echo "<select id='satisfaction_data".$unique_id."' name='satisfaction'>";

            for ($i = 0; $i <= 5; $i++) {
                echo "<option value='$i' " . (($i == $row['rating']) ? 'selected' : '') .
                  ">$i</option>";
            }
            echo "</select>";
            echo "<div class='rateit' id='stars".$unique_id."'></div>";
            // Acumula o JS do rateit para depois
            $rateit_js .= "$(function() { $('#stars$unique_id').rateit({value: " . $row['rating'] . ", min : 0, max : 5, step: 1, backingfld: '#satisfaction_data$unique_id', ispreset: true, resetable: false, readonly: true}); });\n";
            echo "</td>";
             echo "<td>" . nl2br(htmlspecialchars($row['comment'] ?? '')) . "</td>";
             // Campo editável para central_feedback
             echo "<td>";
             echo "<form class='central-feedback-form' data-id='".intval($row['id'])."' style='margin:0;display:flex;align-items:center;' onsubmit='return false;'>";
             echo "<textarea name='central_feedback_edit' rows='10' style='width:90%'>".htmlspecialchars($row['central_feedback'] ?? '')."</textarea>";
             echo "<button type='button' onclick='saveCentralFeedback(this)' class='submit'>Salvar</button>";
             echo "<span class='save-status' style='margin-left:5px;'></span>";
             echo "</form>";
             echo "</td>";
             echo "</tr>";
             $row_index++;
         }
         echo "</table>";
         // Inclui o JS do rateit para todas as linhas
         echo "<script>\n$rateit_js</script>";
      } else {
         echo "<div style='color:gray'>Nenhuma resposta de satisfação registrada para este chamado.</div>";
      }

      // JS para todos os forms (apenas uma vez)
      echo "<script>
      function saveCentralFeedback(btn) {
          var form = btn.closest('form');
          var id = form.getAttribute('data-id');
          var feedback = form.querySelector('textarea[name=\'central_feedback_edit\']').value;
          var status = form.querySelector('.save-status');
          // Sempre pegue o token mais recente
          var csrf = document.querySelector('input[name=\'_glpi_csrf_token\']').value;
          status.textContent = 'Salvando...';

          fetch('".$CFG_GLPI["root_doc"]."/plugins/trt16/front/ajax_update_central_feedback.php', {
                method: 'POST',
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                body: 'id=' + encodeURIComponent(id) +
                      '&central_feedback=' + encodeURIComponent(feedback) +
                      '&_glpi_csrf_token=' + encodeURIComponent(csrf),
                credentials: 'same-origin'
            })
          .then(response => response.json())
          .then(data => {
              if (data.success) {
                  status.textContent = '✔️';
                  setTimeout(() => { location.reload(); }, 500);
              } else {
                  status.textContent = 'Erro ao salvar';
              }
          })
          .catch((err) => {
              status.textContent = 'Erro de conexão: ' + err;
          });
      }
      </script>";
   }

   static function showForTicket($ticket) {
      global $DB;

      $ticket_id = is_object($ticket) ? $ticket->getID() : (isset($ticket['id']) ? $ticket['id'] : null);
      if (!$ticket_id) {
          echo "<div style='color:red'>Erro: não foi possível obter o ID do chamado.</div>";
          return;
      }

      // Consulta os registros de satisfação para este chamado
      $iterator = $DB->request([
          'FROM'  => self::getTable(),
          'WHERE' => ['tickets_id' => $ticket_id]
      ]);

      if (count($iterator)) {
          echo "<table class='tab_cadre' style='width:100%'>";
          echo "<tr>
                  <th style='width:20%'>Data da resposta</th>
                  <th style='width:10%'>Nota</th>
                  <th>Comentário</th>
                  <th>Tratativa Central</th>
                </tr>";
          foreach ($iterator as $row) {
              if (!is_array($row)) continue;
              // Formatar data no padrão brasileiro
              $data_br = '';
              if (!empty($row['date_answered'])) {
                  $dt = DateTime::createFromFormat('Y-m-d H:i:s', $row['date_answered']);
                  if ($dt) {
                      $data_br = $dt->format('d/m/Y H:i');
                  } else {
                      $data_br = $row['date_answered'];
                  }
              }
              echo "<tr>";
              echo "<td>" . htmlspecialchars($data_br) . "</td>";
              echo "<!-- rating: " . htmlspecialchars($row['rating']) . " -->";
              ob_start();
              Dropdown::showRatingField('rating_'.$row['id'], $row['rating'], ['readonly' => true]);
              echo "<td>" . ob_get_clean() . "</td>";
              echo "<td>" . nl2br(htmlspecialchars($row['comment'] ?? '')) . "</td>";
              echo "<td>" . nl2br(htmlspecialchars($row['central_feedback'] ?? '')) . "</td>";
              echo "</tr>";
          }
          echo "</table>";
      } else {
          echo "<div style='color:gray'>Nenhuma resposta de satisfação registrada para este chamado.</div>";
      }
   }

} 



