<?php

class PluginTrt16Profile extends Profile {

   static $rightname = 'profile';


   function rawSearchOptions() {

      $tab = [];

      $tab[] = ['id'                 => 'common',
                'name'               => __('TRT16', 'trt16')];


      $tab[] = ['id'                 => '2',
                'table'              => $this->getTable(),
                'field'              => 'use',
                'linkfield'          => 'id',
                'datatype'           => 'bool'];

      return $tab;
   }


   function getTabNameForItem(CommonGLPI $item, $withtemplate = 0) {
      
      if ($item->getType() == 'Profile' 
          && Session::haveRight('profile', READ)) {
         return __('TRT16', 'trt16');
      }
      return '';
   }


   static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0) {

      if ($item->getType() == 'Profile') {
         $profile = new self();
         $ID = $item->getField('id');
         $profile->showForm($ID);
         return true;
      }
      return false;
   }


   function showForm($ID, $options = []) {
      if (!Session::haveRight("profile", READ)) {
         return false;
      }

      $profile = new Profile();
      $profile->getFromDB($ID);

      if ($canedit = Session::haveRight(self::$rightname, UPDATE)) {
         echo "<form method='post' action='".$profile->getFormURL()."'>";
      }

      echo "<div class='spaced'>";
      
      $rights = [
         [
            'itemtype'  => 'PluginTrt16Menu',
            'label'     => __('Criar Usuário Externo', 'trt16'),
            'field'     => 'plugin_trt16_user_signup',
            'rights'    => [
               READ    => __('Read')
            ]
         ],
         [
            'itemtype'  => 'PluginTrt16Menu',
            'label'     => __('Dashboard de Métricas', 'trt16'),
            'field'     => 'plugin_trt16_metrics_dashboard',
            'rights'    => [
               READ    => __('Read')
            ]
         ],
         [
            'itemtype'  => 'PluginTrt16Menu',
            'label'     => __('Gerenciar Versões de Consentimento', 'trt16'),
            'field'     => 'plugin_trt16_consentimento_versao',
            'rights'    => [
               READ    => __('Read'),
               UPDATE  => __('Update')
            ]
         ]
      ];

      $matrix_options = [
         'title'   => __('TRT16', 'trt16')
      ];
      $matrix_options['canedit'] = $canedit;

      $profile->displayRightsChoiceMatrix($rights, $matrix_options);

      if ($canedit) {
         echo "<div class='center'>";
         echo Html::hidden('id', ['value' => $ID]);
         echo Html::submit(_sx('button', 'Save'), ['name' => 'update']);
         echo "</div>\n";
         Html::closeForm();
      }

      echo "</div>";
   }


   static function updateRights($input) {
      $profile = new Profile();
      $profile->getFromDB($input['id']);

      $rights = self::getAllRights();
      $profileRight = new ProfileRight();

      foreach ($rights as $right) {
         $field = $right['field'];
         $value = isset($input["_$field"]) ? $input["_$field"] : 0;

         $profileRight->updateProfileRights($input['id'], 
            [$field => $value]
         );
      }
   }


   static function getAllRights() {

      $rights = [
         [
            'itemtype'  => 'PluginTrt16Menu',
            'label'     => __('Criar Usuário Externo', 'trt16'),
            'field'     => 'plugin_trt16_user_signup',
            'rights'    => [
               READ    => __('Read')
            ]
         ],
         [
            'itemtype'  => 'PluginTrt16Menu',
            'label'     => __('Dashboard de Métricas', 'trt16'),
            'field'     => 'plugin_trt16_metrics_dashboard',
            'rights'    => [
               READ    => __('Read')
            ]
         ],
         [
            'itemtype'  => 'PluginTrt16Menu',
            'label'     => __('Gerenciar Versões de Consentimento', 'trt16'),
            'field'     => 'plugin_trt16_consentimento_versao',
            'rights'    => [
               READ    => __('Read'),
               UPDATE  => __('Update')
            ]
         ]
      ];

      return $rights;
   }


   static function initProfile() {
      $profile = new self();
      
      // Add new rights in glpi_profilerights table
      foreach ($profile->getAllRights() as $data) {
         ProfileRight::addProfileRights([$data['field']]);
      }
   }


   static function install(Migration $migration) {
      global $DB;
      
      // Init profile rights
      self::initProfile();
      
      // Add default rights to profiles
      foreach ($DB->request('glpi_profiles') as $prof) {
         self::addDefaultProfileInfos($prof['id'], 
            [
               'plugin_trt16_user_signup' => 0,
               'plugin_trt16_metrics_dashboard' => 0
            ]
         );
      }
   }


   static function uninstall() {
      global $DB;
      
      // Remove rights from DB
      $DB->delete('glpi_profilerights', [
         'name' => ['LIKE', 'plugin_trt16_%']
      ]);
   }


   static function addDefaultProfileInfos($profiles_id, $rights) {
      $profileRight = new ProfileRight();
      
      foreach ($rights as $right => $value) {
         if (!countElementsInTable(
            'glpi_profilerights',
            [
               'profiles_id' => $profiles_id,
               'name' => $right
            ]
         )) {
            $profileRight->add([
               'profiles_id' => $profiles_id,
               'name' => $right,
               'rights' => $value
            ]);
         }
      }
   }


   static function removeRightsFromSession() {

      foreach (self::getAllRights() as $right) {
         if (isset($_SESSION['glpiactiveprofile'][$right['field']])) {
            unset($_SESSION['glpiactiveprofile'][$right['field']]);
         }
      }
   }

}