<?php
//if (!defined('GLPI_ROOT')) {
  //  die("Sorry. You can't access directly to this file");
//}

// Class NotificationTarget
/**
 * Class PluginBadgesNotificationTargetBadge
 */
class PluginTRT16NotificationUser extends NotificationTarget {

    const REQUESTER = 30;
    // My events
    const NEW_USER    = "new_user";
    
    /**
     * @return array
     */
    function getEvents() {
        return [
            self::NEW_USER      => __('Novo Usuario', 'user')
            
        ];
    }

    /**
     * Get additionnals targets for Tickets
     *
     * @param string $event
     */
    function addAdditionalTargets($event = '') {
        if ($event == self::NEW_USER) {
            $this->addTarget(self::REQUESTER, __("Requester"));
        }
    }

    function addSpecificTargets($data, $options) {
        //Look for all targets whose type is Notification::ITEM_USER
        switch ($data['type']) {
            case Notification::USER:
                switch ($data['items_id']) {
                    case 30 :
                        $usertype = self::GLPI_USER;
                        $user = new User();
                        $user->getFromDB($options['users_id']);
                        // Send to user without any check on profile / entity
                        // Do not set users_id
                        $data = ['name'     => $user->getName(),
                            'email'    => $user->getDefaultEmail(),
                            'language' => $user->getField('language'),
                            'users_id' => $user->getID(),
                            'usertype' => $usertype];
                        $this->addToRecipientsList($data);
                    break;
                }
        }
    }
}