<?php
ini_set('display_errors', 1);
/**
 * -------------------------------------------------------------------------
 * TRT16 plugin for GLPI
 * -------------------------------------------------------------------------
 */

//if (!defined('GLPI_ROOT')) {
   //die("Sorry. You can't access directly to this file");
//}

include_once(PLUGIN_TRT16_DIR . "/config.php");
class PluginTRT16Metrics{
    private $metricsData;
    private $metricsSpecs;
    private $metricsResume;
    private $metricsDeduction;
    private $startDate;
    private $endDate;
    private $branch;
    private $totalLevelDeduction;
    private $totalMovingCosts = 0;

    function __construct($startDate, $endDate , $branch) {
        global $metricsSpecs;
        $this->metricsSpecs = $metricsSpecs;     
          
        $this->startDate = $startDate;
        $this->endDate = $endDate;
        $this->branch = $branch;

        $ticketsData = $this->getMetricsData($startDate, $endDate);
        $this->metricsData = $this->resolveMetrics($ticketsData);
        $this->metricsResume = $this->resumeMetrics();
    }

    function resolveMetrics($ticketsDetails){
        $indice = 0;
        $metrics = array();
        foreach ($ticketsDetails as $key => $line) {
            $metrics[$indice] = array(
                'ticketsId' => $line['id'],
                'logGroup' => $line['log_group'],
                'logGroupName' => $line['log_group_name'],
                'solveDate' => $line['solvedate'],
                'solveGroup' => $line['solve_group'],
                'solveGroupName' => $line['solve_group_name'],
                'isReopened' => $line['reopen'],
                'N1ActiveDelay' => $line['N1_active_delay'],
                'N1UserPendingDelay' => $line['N1_user_pending_delay'],
                'N1TeamPendingDelay' => $line['N1_team_pending_delay'],
                'N2ActiveDelay' => $line['N2_active_delay'],
                'N2UserPendingDelay' => $line['N2_user_pending_delay'],
                'N2TeamPendingDelay' => $line['N2_team_pending_delay'],
                'N3ActiveDelay' => $line['N3_active_delay'],
                'N3UserPendingDelay' => $line['N3_user_pending_delay'],
                'N3TeamPendingDelay' => $line['N3_team_pending_delay'],
                'N1Eligible' => $line['N1_eligible'],
                'locationId' => $line['locations_id']
            );
            

            $ticketMetrics = new PluginTRT16TicketMetrics($line['id'], $metrics[$indice],$this->branch);
            $metrics[$indice] = array_merge($metrics[$indice],$ticketMetrics->resolveN1Metrics());
            $metrics[$indice] = array_merge($metrics[$indice],$ticketMetrics->resolveN2Metrics());
            $indice++;
            
        }
        
        return $metrics;
        
    }

    function isNaturalNumber($value){
        return is_numeric($value) && $value >= 0;
    }

    function resumeMetrics(){
        $indice = 0;
        //$metricsArray = array("n1.4","n1.5","n1.6","n1.7","n1.8","n1.9","n1.10","n1.11","n1.12","n2.1","n2.2","n2.3","n2.4","n2.5","n2.6","n2.7","n2.8","n2.9","n2.10","n2.11","n2.12","n2.13","n2.14","n2.15");
        $metricsResume = array();
        foreach ($this->metricsSpecs as $key => $specificMetric) {
            
            //Cria um array com a coluna referenta ao indicador em questão. Ex: Array com as medições do indicador n1.4 para todos os chamados
            $specificMetricValues = array_column($this->metricsData, $key);
            
            //Extrai a média dos valores de medição dos indicadores
            $specificMetricValues = array_filter($specificMetricValues, function($value){
                return is_numeric($value) && $value >= 0;
            });
            
            if(count($specificMetricValues)) {
                $metricsResume[$key] = array_sum($specificMetricValues)/count($specificMetricValues);
                if($specificMetric['unit'] == "%"){
                    $metricsResume[$key] *= 100;
                }
            }else{
                $metricsResume[$key] = "";
            }
            $this->metricsDeduction[$key] = round($this->resolveDeduction($specificMetric, $metricsResume[$key]),2);
        }
        return $metricsResume;
        
    }

    function resolveDeduction($metric, $metricValue){
        //=SE(E34<>"";SE(E34>C34;C29*B34*(IMABS(C34-E34))/C34;0);0)
        
        global $N1Value;
        global $N2UnitaryValue;
        global $branchesProfessionals;
        
        if(str_starts_with($metric['metric'],"n2")){
            $branch = $this->branch;
            $nominalValue = $N2UnitaryValue * $branchesProfessionals[$branch];
        }else{
            $nominalValue = $N1Value;
        }
        
        $referenceValue = floatval($metric['value']);
        $measuredValue = floatval($metricValue);
        $impactDegree = floatval($metric['impact']);

        if(empty($measuredValue)) return 0;
        if($metric['requirement'] == "<"){
            if($measuredValue < $referenceValue){
                return 0;
            }else{
                //Fórmula contratual
                return ($nominalValue * $impactDegree * (abs($referenceValue-$measuredValue)))/$referenceValue;   
            }
        }elseif($metric['requirement'] == ">"){
            if($metricValue > $referenceValue){
                return 0;
            }else{
                //C29*B32*(IMABS(C32-E32))/C32
                return ($nominalValue * $impactDegree * (abs($referenceValue-$measuredValue)))/$referenceValue;
            }
        }else{
            return "Erro na configuração da métrica";
        }        
    }

    function getMetricsData($startDate, $endDate){
        global $DB;
        global $N1GroupId;
        global $N2GroupId;

       
        $query = "SELECT distinct 
        t.id, 
        th.log_group,
        g.name as log_group_name,
        t.solvedate,
        th.solve_group,
        g2.name as solve_group_name,
        if(l.id is null,false,true) as reopen,
        SUM( distinct if(th.groups_id = $N1GroupId,th.active_delay,0)) as N1_active_delay,
        SUM( distinct if(th.groups_id = $N1GroupId,th.user_pending_delay,0)) as N1_user_pending_delay,
        SUM( distinct if(th.groups_id = $N1GroupId,th.team_pending_delay,0)) as N1_team_pending_delay,
        SUM( distinct if(th.groups_id = $N2GroupId,th.active_delay,0)) as N2_active_delay,
        SUM( distinct if(th.groups_id = $N2GroupId,th.user_pending_delay,0)) as N2_user_pending_delay,
        SUM( distinct if(th.groups_id = $N2GroupId,th.team_pending_delay,0)) as N2_team_pending_delay,
        SUM( distinct if(th.groups_id not in ($N1GroupId,$N2GroupId),th.active_delay,0)) as N3_active_delay,
        SUM( distinct if(th.groups_id not in ($N1GroupId,$N2GroupId),th.user_pending_delay,0)) as N3_user_pending_delay,
        SUM( distinct if(th.groups_id not in ($N1GroupId,$N2GroupId),th.team_pending_delay,0)) as N3_team_pending_delay,
        elegivelN1.elegvelaoonenvelfield as N1_eligible,
        t.locations_id
        FROM glpi_tickets t  
        LEFT JOIN glpi_plugin_trt16_ticket_history th ON (t.id = th.tickets_id)
        LEFT JOIN glpi_users u ON (t.users_id_recipient = u.id)
        LEFT JOIN glpi_groups g ON (th.log_group = g.id)
        LEFT JOIN glpi_itilsolutions s ON (s.items_id = t.id)
        LEFT JOIN glpi_users u2 ON (s.users_id = u2.id)
        LEFT JOIN glpi_groups g2 ON (th.solve_group = g2.id)
        LEFT JOIN glpi_logs l  ON (l.items_id = t.id and l.itemtype = 'Ticket' and l.old_value = '5' and l.new_value = '2' )
        LEFT JOIN glpi_plugin_fields_itilcategorycatalogoestendidos elegivelN1 ON (t.itilcategories_id = elegivelN1.items_id and plugin_fields_containers_id = 5)
        WHERE s.status <> 4 and t.solvedate between '$startDate' and '$endDate' 
        AND s.solutiontypes_id NOT IN (3 /*Chamado duplicado*/, 4 /*Chamado Aberto Equivocadamente*/)
        AND t.itilcategories_id NOT IN (3 /*Novo Usuário*/, 126 /*Suporte a Eventos e Sessões*/,634 /*Suporte a Sessões do Pleno*/) 
        group by t.id,u.groups_id,t.solvedate,u2.groups_id,if(l.id is null,false,true),elegivelN1.elegvelaoonenvelfield
";  


        //echo $query;
        $it = $DB->request($query);
        
        return $it;
    }

    function getTicketCosts($startDate, $endDate){
        global $DB;
        
        global $branchesLocations;
        $branch = $this->branch;
        
        if($branch == "SLZ"){
            //$filterBranchLocations = " and gt.locations_id not in (" . implode(',',$branchesLocations['ITZ']) . "," . implode(',',$branchesLocations['PRD']) . ")";
            $filterBranchLocations = " and gt.locations_id not in (" . implode(',',$branchesLocations['ITZ']) . ")";
        }else{
            $filterBranchLocations = " and gt.locations_id in (" . implode(',',$branchesLocations[$branch]) . ")";
        }
              
        //pesquisa os custos de todos os chamados de deslocamento da SUTEC. Itil category = 569
        
        $it = $DB->request("select 
                                gtc.name, 
                                gtc.actiontime / 86400 as quantity, 
                                gtc.cost_fixed,
                                gtc.begin_date,
                                gtc.end_date  
                            from glpi_ticketcosts gtc 
                            inner join glpi_tickets gt on (gtc.tickets_id = gt.id)
                            where 
                                (gt.itilcategories_id = 569)
                                ".$filterBranchLocations." 
                                and (gt.solvedate >= '$startDate 00:00:00' and gt.solvedate <= '$endDate 23:59:59') ");
       
        return $it;
    }

    function showMetricsData(){
        $html = "<div class=\"table-responsive-lg\">";
        $html = "<table class=\"search-results table card-table table-hover table-striped\">";
        $html .= "<thead>
        <tr class>
          <th>Chamado</th>
          <th>Grupo de Registro</th>
          <th>Data de Resolução</th>
          <th>Grupo de Resolução</th>
          <th>Reabertura?</th>
          <th>Tempo N1</th>
          <th>Tempo Parado N1</th>
          <th>Tempo N2</th>
          <th>Tempo Parado N2</th>
          <th>Tempo N3</th>
          <th>Tempo Parado N3</th>
          <th>N1.4</th>
          <th>N1.5</th>
          <th>N1.6</th>
          <th>N1.7</th>
          <th>N1.8</th>
          <th>N1.9</th>
          <th>N1.10</th>
          <th>N1.11</th>
          <th>N1.12</th>
          <th>N2.1</th>
          <th>N2.2</th>
          <th>N2.3</th>
          <th>N2.4</th>
          <th>N2.5</th>
          <!--<th>N2.6</th>
          <th>N2.7</th>
          <th>N2.8</th>
          <th>N2.9</th>
          <th>N2.10</th>
          <th>N2.11</th>
          <th>N2.12</th>
          <th>N2.13</th>
          <th>N2.14</th>
          <th>N2.15</th>-->
          
        </tr>
      </thead>
      <tbody>";
      foreach($this->metricsData as $ticketMetrics){
        $html .= "
            <tr>
                <td><span class\"text-nowrap\">".$ticketMetrics['ticketsId']."</span></td>
                <td>".$ticketMetrics['logGroup']."</td>
                <td>".$ticketMetrics['solveDate']."</td>
                <td>".$ticketMetrics['solveGroup']."</td>
                <td>".$ticketMetrics['isReopened']."</td>
                <td>".$ticketMetrics['N1ActiveDelay']."</td>
                <td>".$ticketMetrics['N1UserPendingDelay']."</td>
                <td>".$ticketMetrics['N2ActiveDelay']."</td>
                <td>".$ticketMetrics['N2UserPendingDelay']."</td>
                <td>".$ticketMetrics['N3ActiveDelay']."</td>
                <td>".$ticketMetrics['N3UserPendingDelay']."</td>
                <td>".$ticketMetrics['n1.4']."</td>
                <td>".$ticketMetrics['n1.5']."</td>
                <td>".$ticketMetrics['n1.6']."</td>
                <td>".$ticketMetrics['n1.7']."</td>
                <td>".$ticketMetrics['n1.8']."</td>
                <td>".$ticketMetrics['n1.9']."</td>
                <td>".$ticketMetrics['n1.10']."</td>
                <td>".$ticketMetrics['n1.11']."</td>
                <td>".$ticketMetrics['n1.12']."</td>
                <td>".$ticketMetrics['n2.1']."</td>
                <td>".$ticketMetrics['n2.2']."</td>
                <td>".$ticketMetrics['n2.3']."</td>
                <td>".$ticketMetrics['n2.4']."</td>
                <td>".$ticketMetrics['n2.5']."</td>
                <!--<td>".$ticketMetrics['n2.6']."</td>
                <td>".$ticketMetrics['n2.7']."</td>
                <td>".$ticketMetrics['n2.8']."</td>
                <td>".$ticketMetrics['n2.9']."</td>
                <td>".$ticketMetrics['n2.10']."</td>
                <td>".$ticketMetrics['n2.11']."</td>
                <td>".$ticketMetrics['n2.12']."</td>
                <td>".$ticketMetrics['n2.13']."</td>
                <td>".$ticketMetrics['n2.14']."</td>
                <td>".$ticketMetrics['n2.15']."</td>-->
                
        </tr>";

      }
      $html .= "</tbody></table></div>";
      echo $html;

    }

    function showMetricsDashboard($level){

        $html = "<h3 class=\"navigationheader-title strong d-flex align-items-center\">Indicadores ".strtoupper($level)."</h3>";
        $html .= "<div class=\"card p-3\"><div style=\"display: flex; flex-direction: row;flex-wrap: wrap;justify-content: start;\">"; 
           
                //Extrai os indicadores do nével de serviço passado por parâmetro
        if(strtoupper($level) == "N1"){
            $metricValues = array_filter($this->metricsResume, function($value,$metricKey){
                return str_starts_with($metricKey,"n1");
            },ARRAY_FILTER_USE_BOTH);
        }else{
            $metricValues = array_filter($this->metricsResume, function($value,$metricKey){
                return str_starts_with($metricKey,"n2");
            },ARRAY_FILTER_USE_BOTH);
        }
        $this->totalLevelDeduction[$level] = 0;
        foreach($metricValues as $key => $metricValue){
            $metricId = str_replace(".","_",$key);
            $metricName = strtoupper($key);
            $metricSpec = $this->metricsSpecs[$key];
            if($metricSpec['unit'] == "%"){
                if($metricValue == 100){
                    $decimals = 0;
                }else{
                    $decimals = 2;
                }

            }else{
                $decimals = 0;
            }

            $this->totalLevelDeduction[$level] += $this->metricsDeduction[$key];
            
            $html .=  $this->getCardStyle($metricId, $metricValue , $metricSpec['requirement'] , $metricSpec['value']);
            
            $html .=  "<div   style=\"width:20%; color: #000000; padding:5px;\">
                            <div  class=\"grid-stack-item-content\">      
                                <a id=\"$metricId\" href=\"metrics.form.php?metric=$key&startDate=".$this->startDate."&endDate=".$this->endDate."&branch=".$this->branch."\" class=\"card\" style=\"padding:5px;\" title=\"".$metricSpec['description']."\">
                                    <span class=\"content\">            
                                        <span class=\"formatted-number\" data-precision=\"0\" style=\"width: 100%; font-size: 9px;\">
                                            <span class=\"number\">$metricName</span>
                                            <span class=\"suffix\">".$metricSpec['reference']."</span>
                                        </span>
                                    </span>

                                    <div class=\"label\" title=\"".$metricSpec['description']."\" style=\"text-align:center; width: 100%; font-size: 25px;\">". (is_numeric($metricValue) ? number_format($metricValue,$decimals,",",".") . $metricSpec['unit'] . " <br> - R$ " . number_format($this->metricsDeduction[$key],2,",",".") : "--<br>--" )."</div>
                                    <span style=\"width: 100%; font-size: 9px; \">Referência: ".$metricSpec['requirement']." que ".number_format($metricSpec['value'],$decimals,",",".").$metricSpec['unit']."</span>
                                </a>
                            </div>
                        </div>";
        }

        $html .= "</div> </div><br>";
        
        echo $html;
    }

    function showTicketsFromMetric($metric){
        $metricValue = $this->metricsResume[$metric];
        if($this->metricsSpecs[$metric]['unit'] == "%"){
            if($metricValue == 100){
                $decimals = 0;
            }else{
                $decimals = 2;
            }

        }else{
            $decimals = 0;
        }
        $html = "<div class=\"table-responsive-lg\">";
        
        $html .= "<b>Indicador:</b> " . $this->metricsSpecs[$metric]['metric'] . "<BR>";
        $html .= "<b>Requisito:</b> " . $this->metricsSpecs[$metric]['description'] . "<BR>";
        $html .= "<b>Medição do Indicador:</b> " . (is_numeric($metricValue) ? number_format($metricValue,$decimals,",","."):"--") . $this->metricsSpecs[$metric]['unit'] . "<BR>";
        $html .= "<b>Desconto:</b> R$ " . number_format($this->metricsDeduction[$metric],2,",",".") . "<BR>";
        
        $html .= "<table class=\"search-results table card-table table-hover table-striped\">";
        $html .= "<thead>
        <tr class>
          <th>&nbsp;</th>
          <th>Chamado</th>
          <th>Grupo de Registro</th>
          <th>Data de Resolução</th>
          <th>Grupo de Resolução</th>
          <th>Reabertura?</th>
          <th>Tempo N1</th>
          <th>Parado Usuário N1</th>
          <th>Parado Técnico N1</th>
          <th>Tempo N2</th>
          <th>Parado Usuário N2</th>
          <th>Parado Técnico N2</th>
          <th>Tempo N3</th>
          <th>Parado Usuário N3</th>          
          <th>Parado Técnico N3</th>          
        </tr>
      </thead>
      <tbody>";

    $temp = $this->metricsData;
    if(str_starts_with($metric, 'n1')){
        array_multisort(array_column($temp, 'N1ActiveDelay'), SORT_DESC, $temp);
    }else{
        array_multisort(array_column($temp, 'N2ActiveDelay'), SORT_DESC, $temp);
    }
    foreach($temp as $ticketData){
        //if($ticketData[$metric] === 0){
        //if($ticketData[$metric] === 0 || $ticketData[$metric] === 1){
        
        if($ticketData[$metric] != ""){
            $html .= "
                <tr>
                <td><span class\"text-nowrap\"><a id=\"".$ticketData['ticketsId']."\" href=\"ticket_history.form.php?id=".$ticketData['ticketsId']."\"><i class=\"fa fa-history\"></i></a></span></td>    
                <td><span class\"text-nowrap\"><a id=\"".$ticketData['ticketsId']."\" href=\"/front/ticket.form.php?id=".$ticketData['ticketsId']."\">".$ticketData['ticketsId']."</a></span></td>
                    <td>".($ticketData['logGroupName'] == "" ? "Usuário Final" : $ticketData['logGroupName'])."</td>
                    <td>".$ticketData['solveDate']."</td>
                    <td>".$ticketData['solveGroupName']."</td>
                    <td>".$ticketData['isReopened']."</td>
                    <td>".$ticketData['N1ActiveDelay']."</td>
                    <td>".$ticketData['N1UserPendingDelay']."</td>
                    <td>".$ticketData['N1TeamPendingDelay']."</td>
                    <td>".$ticketData['N2ActiveDelay']."</td>
                    <td>".$ticketData['N2UserPendingDelay']."</td>
                    <td>".$ticketData['N2TeamPendingDelay']."</td>
                    <td>".$ticketData['N3ActiveDelay']."</td>
                    <td>".$ticketData['N3UserPendingDelay']."</td>
                    <td>".$ticketData['N3TeamPendingDelay']."</td>
            </tr>";
        } 
      }
      $html .= "</tbody></table></div>";
      echo $html;

    }

    function showTotalDeduction(){
        global $N1Value;
        global $N2UnitaryValue;
        global $branchesProfessionals;
        global $N2ManagerValue;
        $sumLevelDeduction = 0;
        $sumNominalValue = 0;
        $html = "<h3 class=\"navigationheader-title strong d-flex align-items-center\">Resumo</h3>";
        $html .= "<div class=\"card p-3\"><div style=\"display: flex; flex-direction: row;flex-wrap: wrap;justify-content: start;\">"; 
        $html .= "<div class=\"table-responsive-lg\">";
        $html .= "<table class=\"search-results table card-table table-hover table-striped\">";
        $html .= "<tr>";
        
        foreach($this->totalLevelDeduction as $level => $deduction){
            if($level != "n1"){
                $branch = $this->branch;
                $nominalValue = $N2UnitaryValue * $branchesProfessionals[$branch];
            }else{
                $nominalValue = $N1Value;
            }
            $sumLevelDeduction += $this->totalLevelDeduction[$level];
            $levelValueAfterDeductions = $nominalValue - $this->totalLevelDeduction[$level];
            $html .= "<td>";
            $html .= "<h3>Nível: " . strtoupper($level) . "</h3>";
            $html .= "<b>Valor Original:</b> <span style=\"color:green;\">R$ " . number_format($nominalValue,2,',','.') . "</span><BR>";
            $html .= "<b>Total de Descontos:</b> <span style=\"color:red;\">R$ " . number_format($this->totalLevelDeduction[$level],2,',','.') . "</span><BR>";
            $html .= "<b>Valor Final:</b> <span style=\"color:blue;\">R$ " . number_format($levelValueAfterDeductions,2,',','.') . "</span><BR>";
            $html .= "</td>";
            $sumNominalValue += $nominalValue;
        }

        $html .= "<td>";
        $html .= "<h3>Total da Nota de ". $this->branch ."</h3>";
        $html .= "<b>Valor Original:</b> <span style=\"color:green;\">R$ " . number_format($sumNominalValue,2,',','.') . "</span><BR>";
        $html .= "<b>Total de Descontos:</b> <span style=\"color:red;\">R$ " . number_format($sumLevelDeduction,2,',','.') . "</span><BR>";
        if($level == "n2"){
            $html .= "<b>Valor de Viagens:</b> <span style=\"color:green;\">R$ " . number_format($this->totalMovingCosts,2,',','.') . "</span><BR>";
            $sumNominalValue += $this->totalMovingCosts;
            if($this->branch == "SLZ"){
                $html .= "<b>Valor de Supervisão:</b> <span style=\"color:green;\">R$ " . number_format($N2ManagerValue,2,',','.') . "</span><BR>";
                $sumNominalValue += $N2ManagerValue;
            }
        }
        
        $html .= "<b>Valor Final:</b> <span style=\"color:blue; font-size=1em\">R$ " . number_format($sumNominalValue - $sumLevelDeduction,2,',','.') . "</span><BR>";
        $html .= "</td>";

        $html .= "</tr></table></div></div></div><br>";
        echo $html;

    }

    function showN2MovingCosts($startDate, $endDate){
        
        $sumCosts = 0;
        
        $costs = $this->getTicketCosts($startDate, $endDate);
                
        $html = "<h3 class=\"navigationheader-title strong d-flex align-items-center\">Valores Variáveis - Diárias e Deslocamentos</h3>";
        $html .= "<div class=\"card p-3\"><div style=\"display: flex; flex-direction: row;flex-wrap: wrap;justify-content: start;\">"; 
        $html .= "<div class=\"table-responsive-lg\">";

        if(!empty($costs->current())){

            $html .= "<table class=\"search-results table card-table table-hover table-striped\"><thead><tr>";
            $html .= "<th>Descrição</th>";
            $html .= "<th>Data Ida</th>";
            $html .= "<th>Data Volta</th>";
            $html .= "<th>Quantidade</th>";
            $html .= "<th>Valor</th>";
            $html .= "</tr></thead>";
           
           
            foreach($costs as $cost){
                
                $sumCosts += $cost['cost_fixed'];
                if(!empty($cost['begin_date'])){
                    $date1 = date_create($cost['begin_date']);
                    $beginDate = date_format($date1,"d-m-Y");

                }
                if(!empty($cost['end_date'])){
                    $date2 = date_create($cost['end_date']);
                    $endDate = date_format($date2,"d-m-Y");
                }
                
                $html .= "<tr>";
                $html .= "<td>".$cost['name']."</td>";
                $html .= "<td>".$beginDate."</td>";
                $html .= "<td>".$endDate."</td>";
                $html .= "<td align='center'>".number_format($cost['quantity'],0)."</td>";
                $html .= "<td  align='right'>R$ ".number_format($cost['cost_fixed'],2,',','.')."</td>";
                $html .= "</tr>";
            }
            $html .= "<tfoot><tr>";
            $html .= "<td align='right' colspan=\"4\"><b>Total: </b></td>";
            $html .= "<td align='right'>R$ ".number_format($sumCosts,2,',','.')."</td>";
            $html .= "</tr></tfoot>";
           
            $html .= "</table></div></div></div><br>";

            $this->totalMovingCosts = $sumCosts;
        }else{
            $html .= "<h3 style=\"color:red\">Não foram registradas viagens no período!</h3></div></div></div><br>";
        }
        echo $html;

    }

    function getCardStyle($metricId, $measuredValue , $requirement , $expectedValue){
        if(!is_numeric($measuredValue)){
            return "<style>
            #$metricId {
               background-color: #f7d79a;
               color: #b77d0e;
            }
   
            #$metricId:hover {
               background-color: #f1bb53;
               border: 1px solid #e69d12;
            }
   
            .theme-dark #$metricId {
               background-color: #b77d0e;
               color: #f7d79a;
            }
   
            .theme-dark #$metricId:hover {
               background-color: #f1bb53;
               color: #b77d0e;
               border: 1px solid #e69d12;
            }
         </style>";
        }

        $notReachedStyle = "<style>
        #$metricId {
           background-color: #dc6f6f;
           color: #661919;
        }

        #$metricId:hover {
           background-color: #cd3232;
           border: 1px solid #8f2323;
        }

        .theme-dark #$metricId {
           background-color: #661919;
           color: #dc6f6f;
        }

        .theme-dark #$metricId:hover {
           background-color: #cd3232;
           color: #661919;
           border: 1px solid #8f2323;
        }
     </style>";

     $reachedStyle = "<style>
     #$metricId {
        background-color: #9bc06b;
        color: #32431c;
     }

     #$metricId:hover {
        background-color: #759c42;
        border: 1px solid #4d662c;
     }

     .theme-dark #$metricId {
        background-color: #32431c;
        color: #9bc06b;
     }

     .theme-dark #$metricId:hover {
        background-color: #759c42;
        color: #32431c;
        border: 1px solid #4d662c;
     }
  </style>";
        
        if($requirement == "<"){
            if($measuredValue <= $expectedValue){
                //Incicador atendido
                return $reachedStyle;
            }else{
                //Incicador NÃO atendido
                return $notReachedStyle;
            }
        }else{
            if($measuredValue >= $expectedValue){
                //Incicador atendido
                return $reachedStyle;
            }else{
                //Incicador NÃO atendido
                return $notReachedStyle;
            }
        }
        return "#f7d79a";
    }
}