<?php

/**
 * -------------------------------------------------------------------------
 * TRT16 plugin for GLPI
 * -------------------------------------------------------------------------
 */

class PluginTRT16Menu extends CommonGLPI{

   static $rightname = 'plugin_datainjection_use';

   static function getMenuName() {

      return __('Indicadores N1/N2', 'trt16');
   }

   static function getMenuContent() {

      global $CFG_GLPI;

      $injectionFormUrl = "/".Plugin::getWebDir('trt16', false).'/front/metrics_dashboard.form.php';

      $menu = [
         'title' => self::getMenuName(),
         'page'  => $injectionFormUrl,
         'icon'  => 'fa-solid fa-filter-circle-dollar',
      ];

      if (Session::haveRight(static::$rightname, READ)) {
         
         $image_import  = "<i class='fa-solid fa-filter-circle-dollar' title='";
         $image_import .= __s('Indicadores N1/N2', 'trt16');
         $image_import .= "' alt='".__s('Indicadores N1/N2', 'trt16')."'></i>";

         $menu['options'] = [
            'client' => [
               'title' => __s('Indicadores N1/N2', 'trt16'),
               'page'  => $injectionFormUrl,
               'icon'  => 'fa-solid fa-filter-circle-dollar',
            ],
            'model' => [
               'icon'  => 'fas fa-layer-group',
               'links' => [
                  $image_import => $injectionFormUrl
               ]
            ]
         ];

         $model_name  = PluginDatainjectionModel::getTypeName(Session::getPluralNumber());
         $image_model = "<i class='fas fa-layer-group' title='$model_name' alt='$model_name'></i>";

         if (Session::haveRight('plugin_datainjection_model', READ)) {
            $menu['options']['model']['title'] = $model_name;
            //$menu['options']['model']['page'] = Toolbox::getItemTypeSearchUrl('PluginDatainjectionModel', false);
            //$menu['options']['model']['links']['search'] = Toolbox::getItemTypeSearchUrl('PluginDatainjectionModel', false);
            //$menu['options']['client']['links'][$image_model]  = Toolbox::getItemTypeSearchUrl('PluginDatainjectionModel', false);
         }

         //if (Session::haveRight('plugin_datainjection_model', UPDATE) || Session::haveRight('plugin_datainjection_model', CREATE)) {
         //   $menu['options']['model']['links']['add'] = Toolbox::getItemTypeFormUrl('PluginDatainjectionModel', false);
         //   $menu['options']['client']['links'][$image_model]  = Toolbox::getItemTypeSearchUrl('PluginDatainjectionModel', false);
         //}

      }

      return $menu;
   }


}