<?php
if (!defined('GLPI_ROOT')) {
   die("Sorry. You can't access this file directly");
}

class PluginTrt16ConsentimentoVersao extends CommonDBTM {
   public static $rightname = 'plugin_trt16_consentimento_versao';

   static function getTypeName($nb = 0) {
      return _n('Versão de Consentimento', 'Versões de Consentimento', $nb, 'trt16');
   }

   static function canCreate() {
      return Session::haveRight(self::$rightname, CREATE);
   }
   static function canView() {
      return Session::haveRight(self::$rightname, READ);
   }
   static function canUpdate() {
      return Session::haveRight(self::$rightname, UPDATE);
   }
   static function canDelete() {
      return Session::haveRight(self::$rightname, DELETE);
   }

   function getTabNameForItem(CommonGLPI $item, $withtemplate = 0) {
      return self::getTypeName(1);
   }

   function defineTabs($options = []) {
      $ong = [];
      $this->addDefaultFormTab($ong);
      return $ong;
   }

   function showForm($ID, $options = []) {
      global $DB, $CFG_GLPI;
      if (!Session::haveRight(self::$rightname, READ)) {
         return false;
      }
      $this->initForm($ID, $options);
      $this->showFormHeader($options);
      echo '<tr class="tab_bg_1">';
      echo '<td>' . __('Texto do Consentimento', 'trt16') . '</td>';
      echo '<td>';
      echo '<textarea name="consentimento_texto" rows="6" cols="80">' .
         Html::clean($this->fields['consentimento_texto'] ?? '') . '</textarea>';
      echo '</td>';
      echo '</tr>';
      echo '<tr class="tab_bg_1">';
      echo '<td>' . __('Ativo', 'trt16') . '</td>';
      echo '<td>';
      Dropdown::showYesNo('ativo', $this->fields['ativo'] == 'S' ? 1 : 0);
      echo '</td>';
      echo '</tr>';
      $this->showFormButtons($options);
      return true;
   }
} 