<?php

if (!defined('GLPI_ROOT')) {
   die("Sorry. You can't access this file directly");
}

include_once(__DIR__ . "/inc/bootstrap.php");
include_once(__DIR__ . "/inc/ticket_delays.class.php");

/**
 * -------------------------------------------------------------------------
 * TRT16 plugin for GLPI
 * Copyright (C) {YEAR} by the TRT16 Development Team.
 * -------------------------------------------------------------------------
 *
 * MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * --------------------------------------------------------------------------
 */

/**
 * Plugin install process
 *
 * @return boolean
 */
function plugin_trt16_install()
{
    global $DB;

    //instanciate migration with version
    $migration = new Migration(PLUGIN_TRT16_VERSION);

    //Create table only if it does not exists yet!
    if (!$DB->tableExists('glpi_plugin_trt16_ticket_history')) {
        //table creation query
        $query = "CREATE TABLE glpi_plugin_trt16_ticket_history (
            tickets_id INT UNSIGNED NOT NULL,
            groups_id INT UNSIGNED NOT NULL,
            active_delay INT UNSIGNED,
            user_pending_delay INT,
            team_pending_delay INT,
            close_date DATETIME,
            N3_assignment_delay INT UNSIGNED,
            log_group INT,
            solve_group INT,
            justification_date DATETIME,
            justification VARCHAR(255),
            PRIMARY KEY(tickets_id,groups_id)
            ) ENGINE=InnoDB";
        $DB->queryOrDie($query, $DB->error());
    }
    
    // Criar tabela de versões do consentimento
    if (!$DB->tableExists('glpi_plugin_trt16_consentimento_versao')) {
        $query = "CREATE TABLE glpi_plugin_trt16_consentimento_versao (
            id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            consentimento_texto TEXT,
            ativo CHAR(1)
            ) ENGINE=InnoDB";
        $DB->queryOrDie($query, $DB->error());
    }

    // Criar tabela de consentimentos LGPD
    if (!$DB->tableExists('glpi_plugin_trt16_consentimento_lgpd')) {
        $query = "CREATE TABLE glpi_plugin_trt16_consentimento_lgpd (
            id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            data_hora DATETIME,
            consentimento_versao_id INT UNSIGNED,
            ip VARCHAR(50),
            glpi_users_id INT UNSIGNED,
            glpi_users_registro_id INT UNSIGNED
            ) ENGINE=InnoDB";
        $DB->queryOrDie($query, $DB->error());
    }
    
    // Criar tabela de avaliações de satisfação TRT16
    if (!$DB->tableExists('glpi_plugin_trt16_satisfactions')) {
        $query = "CREATE TABLE glpi_plugin_trt16_satisfactions (
            id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            tickets_id INT(11) UNSIGNED NOT NULL,
            user_id INT(11) UNSIGNED NOT NULL,
            rating INT(1) NOT NULL,
            comment TEXT,
            central_feedback LONGTEXT,
            date_answered DATETIME NOT NULL,
            items_id INT(11) UNSIGNED,
            itemtype VARCHAR(255),
            possui_feedback_central INT UNSIGNED NOT NULL DEFAULT 0
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
        $DB->queryOrDie($query, $DB->error());
    }
    
    // Install profile rights
    PluginTRT16Profile::install($migration);

    //execute the whole migration
    $migration->executeMigration();

    return true;
}

/**
 * Plugin uninstall process
 *
 * @return boolean
 */
function plugin_trt16_uninstall()
{
    global $DB;

    // Remove profile rights
    PluginTRT16Profile::uninstall();

    /*
    // Remove plugin tables
    $tables = [
        'ticket_history',
        'consentimento_versao',
        'consentimento_lgpd'
    ];

    foreach ($tables as $table) {
        $tablename = 'glpi_plugin_trt16_' . $table;
        if ($DB->tableExists($tablename)) {
            $DB->queryOrDie(
                "DROP TABLE `$tablename`",
                $DB->error()
            );
        }
    }
    */

    return true;
}

function plugin_trt16_postinit() {
   global $CFG_GLPI, $PLUGIN_HOOKS;
   print_r($PLUGIN_HOOKS);
   foreach ($PLUGIN_HOOKS['trt16'] as $type => $typepdf) {
      CommonGLPI::registerStandardTab($type, $typepdf);
   }
}

function plugin_trt16_display_login() {
    echo Html::css(Plugin::getPhpDir('trt16', false) . "/css/styles.css");
    
    echo "<div class=\"col-auto px-2 text-center\">
               <div class=\"plugin_news_alert-login\">
                   <div class=\"plugin_news_alert-container row align-items-stretch\">
                       <style>
                           :root { --tblr-lime: #74b816; }
                       </style>
                       <div><br>Opções para usuários externos:</div>
                       <div class=\"plugin_news_alert col-xxl-8 col-xl-8 col-12\" data-id=\"1\">";
    echo '<a href="'.Plugin::getWebDir('trt16', true) .'/front/user_signup.form.php">Criar Conta</a>';
    echo '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
    echo '<a href="http://central.trt16.jus.br/front/lostpassword.php">Esqueci minha senha</a>';
    echo "</div></div></div>";
}

function plugin_trt16_ticket_update(Ticket $item) {
    $ticketId = $item->fields['id'];
    $status = $item->fields['status'];
          //echo '<script>alert("plugin_trt16_pre_item_update_ticket", ' . $ticketId . ' ' . $status . ' );</script>';
    //Status = 5 é solucionado
    if($status == 5){
        $ticketDelays = new PluginTRT16TicketDelays($ticketId);
        $ticketDelays->resolveGroupsDelays();
        $ticketDelays->saveTicketDelays();
    }
}

/**
 * Retorna a página de configuração do plugin para o menu do GLPI
 */
/*
function plugin_getConfigPage_trt16() {
    global $CFG_GLPI;
    // Adiciona submenu para versões de consentimento
    $menu = [
        'title' => __('Configuração TRT16', 'trt16'),
        'page'  => $CFG_GLPI['root_doc'] . "/plugins/trt16/front/config.form.php",
        'options' => [
            'consentimento_versao' => [
                'title' => __('Versões de Consentimento', 'trt16'),
                'page'  => $CFG_GLPI['root_doc'] . "/plugins/trt16/front/consentimento_versao.form.php"
            ]
        ]
    ];
    return $menu;
}
*/



 
function plugin_trt16_getAddSearchOptions($itemtype) {
    if ($itemtype === 'Ticket') {
        return [ 9500 =>
            [
                'id'                      => 9500, // identificador único
                'table'                   => 'glpi_plugin_trt16_satisfactions',
                'field'                   => 'rating',
                'linkfield'               => 'id',
                'name'                    => __('Nota de Satisfação TRT16'),
                'datatype'                => 'text',
                'forcegroupby'            => true,
                'massiveaction'           => false,
                'joinparams'              => [
                    'jointype' => 'itemtype_item',
                    'alias'    => 'satisfaction_rating'
                ]
            ],
            9501 => 
            [
                'id'                      => 9501, // outro identificador único
                'table'                   => 'glpi_plugin_trt16_satisfactions',
                'field'                   => 'central_feedback',
                'linkfield'               => 'id',
                'name'                    => __('Tratativa Central TRT16'),
                'datatype'                => 'text',
                'forcegroupby'            => true,
                'joinfield'               => 'items_id',
                'condition'               => [
                    'itemtype' => 'Ticket'
                ],
                'massiveaction'           => false,
                'searchtype'              => 'equals'
            ],
                9502 => 
                [
                    'id'                      => 9502, // outro identificador único
                    'table'                   => 'glpi_plugin_trt16_satisfactions',
                    'field'                   => 'possui_feedback_central',
                    'linkfield'               => 'id',
                    'name'                    => __('Possui Tratativa Central TRT16'),
                    'datatype'                => 'bool',
                    'forcegroupby'            => true,
                    'joinfield'               => 'items_id',
                    'condition'               => [
                        'itemtype' => 'Ticket'
                    ],
                    'massiveaction'           => false,
                    'searchtype'              => 'equals'
                    
                ]
            
        ];
    }

    return [];
}

function plugin_trt16_pre_item_update_ticket2(Ticket $ticket) {
    
    
    // O input que será salvo
    $input = $ticket->input;
    $ticket_id = isset($input['id']) ? (int)$input['id'] : 0;
    
    if(isset($input['_actors']) and $ticket_id > 0){
    
        global $DB;
        

    
        $group_id = "";
        
        
        $status = (int)$input['status'];
    
    
        $atores_atribuidos = $input['_actors']['assign'];
        foreach($atores_atribuidos as $ator){
            if($ator['itemtype'] == 'Group'){
                $group_id = $ator['items_id'];       
            }
        }
    
        // Só age se está tentando mudar o grupo
        if (!empty($group_id)) {
            
            if ($ticket_id > 0) {
                // Busca o grupo atual e status no banco
                //$query = "SELECT t.status, tg.groups_id FROM glpi_tickets t LEFT JOIN glpi_groups_tickets tg ON tg.tickets_id = t.id AND tg.type = 2 WHERE t.id = $ticket_id";
                $query = "SELECT tg.groups_id FROM glpi_groups_tickets tg WHERE tg.tickets_id = $ticket_id AND tg.type = 2";
                $result = $DB->query($query);
                if ($result && $DB->numrows($result) > 0) {
                    if (method_exists($DB, 'fetch_assoc')) {
                        $row = $DB->fetch_assoc($result);
                    } else {
                        $row = mysqli_fetch_assoc($result);
                    }
                    //$status_novo = (int)$row['status'];
                    $grupo_atual = (int)$row['groups_id'];
                    $grupo_novo = (int)$group_id;
                                
                    
                    // Status 4 = Pendente (GLPI padrão)
                    if ($status === 4 && $grupo_novo !== $grupo_atual) {
                        foreach($ticket->input['_actors']['assign'] as $ator){
                            if($ator['itemtype'] == 'Group'){
                                $ator['items_id'] = $grupo_atual;       
                            }
                        }
                        $ticket->input['status'] = 2;
                        //unset($ticket->input['_actors']); // Impede a alteração de grupo
                        //Session::addMessageAfterRedirect(__('Não é permitido encaminhar chamados com status Pendente.', 'trt16'), false, ERROR);
                        return true;
                    }
                }
            }
            return true;
        }
    }
    
    return true;

}





    

