<?php
/**
 * -------------------------------------------------------------------------
 * TRT16 plugin for GLPI
 * -------------------------------------------------------------------------
 */

//include_once(GLPI_ROOT . "/inc/includes.php");
//$path = Plugin::getPhpDir("trt16");
//include_once("$path/inc/ticket_delays.class.php");
//include_once (GLPI_ROOT . "/inc/includes.php");
use Glpi\Application\View\TemplateRenderer;
include_once ("../../../inc/includes.php");
include_once(PLUGIN_TRT16_DIR . "/inc/user_signup.class.php");

// Se acessado via menu (usuário logado), verifica permissão
if (isset($_SESSION['glpiactiveprofile'])) {
    Session::checkRight("user", READ);
}

Html::nullHeader("Criar Conta", []); // Isso vai incluir os CSS e JS necessários do GLPI

// CSS personalizado
echo "<style>
.error { 
    text-align: left; 
    color: red; 
    font-size: 14px;
}

.page .glpi-logo {
    background: url(\"https://www.trt16.jus.br/sites/portal/files/roles/central_de_servicos/logo_TRT16_100width.png\") no-repeat;
    height: 75px;
    width: 100px;
}

.page-anonymous .glpi-logo {
    --logo: url(\"https://www.trt16.jus.br/sites/portal/files/roles/central_de_servicos/Logo_TRT_Fundo_branco_200width.png\");
    content: var(--logo);
    width: 200px;
    height: 153px;
}

.checkboxes {
    display: flex;
    flex-direction: row;
    flex-wrap: wrap;
}

#plugin_formcreator_form .form-group .form_field .radio, 
#plugin_formcreator_form .form-group .form_field .checkbox {
    padding-bottom: 1em;
    width: 50%;
}
</style>";

//Html::header(__("TRT16", "trt16"), '', "plugins", "trt16", "userSignup");
//include('../../../templates/layout/parts/head.html.twig');
/*
TemplateRenderer::getInstance()->display('@assetlist/signup.form.html.twig', [
   'title' => __('Forgotten password?'),
]);

*/

echo "<div class=\"page-anonymous\">
   <div class=\"flex-fill d-flex flex-column justify-content-center py-4 mt-4\">
      <div class=\"container-tight py-6\" style=\"max-width: 60rem\">
         <div class=\"text-center\">
            <div class=\"col-md\">
               <span class=\"glpi-logo mb-4\" title=\"GLPI\"></span>
            </div>
         </div>
         <div class=\"card card-md\">
            <div id=\"container_principal\" class=\"card-body\">";
      
            if(isset($_GET['action']) && $_GET['action'] == "success"  ){    
               echo "<div class='alert alert-important alert-info' role='alert'><h3>Sucesso</h3><p>Seu cadastro foi realizado com sucesso, você vai receber um email com informações necessárias para configurar sua senha. Por favor, feche essa janela e acesse o link enviado por e-mail. <br>Se você não receber um email, entre em contato com a Central de Atendimento através do e-mail cati@trt16.jus.br ou pelo telefone (98) 2109-9500 .</p></div>"; 
            }else{
               echo "<form method=\"get\" name=\"form_signup\" id=\"form_signup\" action=\"user_signup.form.php\"><input type=\"hidden\" name=\"action\" value=\"run\">
                  <div class=\"row justify-content-center\">
                  <div class=\"col-md-5\">
                  <div class=\"card-header mb-4\">
                     <h2 class=\"mx-auto\">Cadastre-se</h2>
                  </div>
               <span id=\"formError\" class=\"error\"></span>
                  <div class=\"mb-3\">
                     <label class=\"form-label\" for=\"cpf\">CPF (Campo utilizado para acessar o sistema):<span class=\"error\"> *</span></label>       
                     <input type=\"text\" class=\"form-control\" name=\"cpf\" id=\"cpf\" size=\"15px\" placeholder=\"000.000.000-00\" maxlength=\"14\" required>
                     <span id=\"cpfError\" class=\"error\" ></span>
                  </div>
                  <div class=\"mb-3\">
                  <label class=\"form-label\" for=\"fullName\">Nome Completo:<span class=\"error\"> *</span></label>      
                  <input type=\"text\" class=\"form-control\" name=\"fullName\" required>
                  </div>
                  <div class=\"mb-3\">     
                  <label class=\"form-label\" for=\"email\">E-mail:<span class=\"error\"> *</span></label> 
                  <input type=\"text\" class=\"form-control\"  name=\"email\" id=\"email\" required> 
                  <span id=\"emailError\" class=\"error\"></span> 
                  </div>
                  <div class=\"mb-3\">
                  <label class=\"form-label\" for=\"categoria\">Categoria:<span class=\"error\"> *</span></label> 
                  <select class=\"form-control\" size=\"1\" name=\"categoria\" required>
                     <option value=\"9\">Selecione</option>
                     <option value=\"13\">Advogado(a)</option>
                     <option value=\"12\">Aposentado(a)/Pensionista</option>
                     <option value=\"14\">Ministério Público</option>
                     <option value=\"16\">Perito(a)/Tradutor(a)/Intérprete</option>
                     <option value=\"15\">Estudante</option>
                     <option value=\"9\">Outro</option>
                  </select>
                     </div>
                  <div class=\"mb-3\">
                  <label class=\"form-label\" for=\"oab\">OAB:</label> 
                  <input type=\"text\" class=\"form-control\" size=\"15px\" name=\"oab\" placeholder=\"UF999999\"> 
                     </div>
                  <div class=\"mb-3\">
                  <label class=\"form-label\" for=\"phone\">Telefone para contato:</label> 
                  <input type=\"text\" class=\"form-control\" size=\"15px\" name=\"phone\" placeholder=\"(99) 99999-9999\" pattern=\"[0-9() ]*\" > 
                     </div>
                  <div class=\"form-footer\">
                        <span style=\"text-align: justify; display: block;\">
                           Os dados coletados são utilizados exclusivamente para prestar suporte, gerenciar solicitações e melhorar nossos serviços. Comprometemo-nos a manter suas informações seguras e utilizá-las conforme a Lei Geral de Proteção de Dados (LGPD).
                        </span>
                        <span style=\"display: flex; align-items: center; margin-top: 10px;\">
                           <input type=\"checkbox\" id=\"consentimento\" name=\"consentimento\" style=\"margin-right: 5px;\" required />
                           <label for=\"consentimento\">Você consente com o tratamento dos seus dados?</label>
                        </span>
                  </div>
                  <div class=\"form-footer\">
                        <input type=\"submit\" class=\"btn btn-primary w-100\" value=\"Salvar\">
                  </div>
               </div></div>
               </form>";
   
         }
         echo "<div class=\"text-center text-muted mt-3\">Esqueça, <a href=\"/index.php\"> me envie de volta</a> para a página de login.</div>";
   
   echo "<script>
   document.addEventListener('DOMContentLoaded', function () {
      const cpfInput = document.getElementById('cpf');
      const emailInput = document.getElementById('email');
      const form = document.getElementById('form_signup');
      const cpfError = document.getElementById('cpfError');
      const emailError = document.getElementById('emailError');
   
      // Função para aplicar a máscara de CPF
      cpfInput.addEventListener('input', function () {
          let cpf = cpfInput.value.replace(/\D/g, '');
          cpf = cpf.replace(/(\d{3})(\d)/, '$1.$2');
          cpf = cpf.replace(/(\d{3})(\d)/, '$1.$2');
          cpf = cpf.replace(/(\d{3})(\d{1,2})$/, '$1-$2');
          cpfInput.value = cpf;
      });
   
      // Função para validar CPF e Email
      form.addEventListener('submit', validarSubmit);
   
      cpf.addEventListener('change', validar);
      email.addEventListener('change', validar);
   
      // Função para validar CPF e Email
      function validarSubmit(event) {
         if(validar(event)){
            form.submit();
         }else{
            return false;
         }
      }
      // Função para validar CPF e Email
      function validar(event) {
          event.preventDefault();
          cpfError.textContent = ''; // Limpa erros anteriores
          emailError.textContent = ''; // Limpa erros anteriores
   
          const cpf = cpfInput.value.replace(/\D/g, '');
          const email = emailInput.value;
   
          let valid = true;
   
          // Validar CPF
          if (!isValidCPF(cpf)) {
              cpfError.textContent = 'CPF inválido. Por favor, insira um CPF válido.';
              valid = false;
          }
   
          // Validar Email
          if (!isValidEmail(email)) {
              emailError.textContent = 'Email inválido. Por favor, insira um email válido.';
              valid = false;
          }
   
          if (valid) {
            return true;
          }else{
            return false;
          }
      }
   
      // Função para validar o CPF (regra básica)
      function isValidCPF(cpf) {
         if(cpf.length == 0) return true; 
          if (cpf.length !== 11 || /^(\d)\1+$/.test(cpf)) {
              return false;
          }
   
          let soma = 0;
          let resto;
          for (let i = 1; i <= 9; i++) {
              soma += parseInt(cpf.substring(i - 1, i)) * (11 - i);
          }
          resto = (soma * 10) % 11;
   
          if ((resto === 10) || (resto === 11)) resto = 0;
          if (resto !== parseInt(cpf.substring(9, 10))) return false;
   
          soma = 0;
          for (let i = 1; i <= 10; i++) {
              soma += parseInt(cpf.substring(i - 1, i)) * (12 - i);
          }
          resto = (soma * 10) % 11;
   
          if ((resto === 10) || (resto === 11)) resto = 0;
          if (resto !== parseInt(cpf.substring(10, 11))) return false;
   
          return true;
      }
   
      // Função para validar o Email
      function isValidEmail(email) {
         
         if(email.length == 0) return true; 
         
         // Expressão regular para validar email
          const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
          return emailRegex.test(email);
      }
   });
   
   function checkConsentimento() {
      var consentCheckbox = document.getElementById('consentimento');
      if (!consentCheckbox.checked) {
         consentCheckbox.setCustomValidity(\"Você precisa dar o consentimento para tratamento de dados pessoais antes de prosseguir!\");
      } else {
         consentCheckbox.setCustomValidity(\"\"); // Reseta a mensagem de erro
      }
      return consentCheckbox.checkValidity(); // Verifica se o campo é válido
   }
   </script>";
      
echo "         <div class=\"text-center text-muted mt-3\">
               <a href=\"https://glpi-project.org/\" title=\"Powered by Teclib and contributors\" class=\"copyright\">GLPI Copyright (C) 2015-2024 Teclib' and contributors</a>
         </div>
      </div>
   </div>
</div>

<div style=\"background-image: url('/glpi/front/cron.php');\"></div></div></div></body>";
if(isset($_GET['action']) && $_GET['action'] == "run"  ){
   
   $signup = new PluginTRT16UserSignup();
   $fullName = splitFullName($_GET["fullName"]);
   $cpf = preg_replace('/\D/', '', $_GET["cpf"]);
   $phone = $_GET["phone"];
   $oab = $_GET["oab"];
   $email = $_GET["email"];
   $categoria_id = $_GET["categoria"];
   $consentimento = $_GET["consentimento"];
   
   //$active_delay = $_GET["delay"];
   //$message = $_GET["message"];
   $input = '{"input": [{
      "name": "' . $cpf . '",
      "firstname": "'. $fullName['firstName'] . '",
      "realname": "'. $fullName['lastName'] . '",
      "registration_number": "'. $cpf . '",
      "phone": "'. $phone . '",
      "comment": "OAB: '. $oab . '",
      "email": "'. $email . '",
      "usercategories_id": "'. $categoria_id .'",
      "locations_id": "87",
      "is_active" : 1
    }]}';

   $retorno = $signup->createUser($input);
   //print_r($retorno);
   //$retorno = json_decode($retorno,true); 
   //print_r($retorno);
   if(!empty($retorno['id'])){
      
      $sucesso = "<div class='alert alert-important alert-info' role='alert'><h3>Sucesso</h3><p>Seu cadastro foi realizado com sucesso, você vai receber um email com informações necessárias para configurar sua senha. Por favor, feche essa janela e acesse o link enviado por e-mail. <br><br>Se você não receber um email, entre em contato com a Central de Atendimento através do e-mail cati@trt16.jus.br ou pelo telefone (98) 2109-9500.</p></div><div class='text-center text-muted mt-3'>Esqueça, <a href='/index.php'> me envie de volta</a> para a página de login.</div>";

      
      echo "<script>document.getElementById('action').value = 'success';</script>";
      echo "<script>document.getElementById('container_principal').innerHTML = \"".$sucesso."\";</script>";
   }else{
      echo "<script>document.getElementById('formError').textContent = '".$retorno['message']."';</script>";
   }
}

function splitFullName($fullName) {
   // Verifica se a entrada é uma string não vazia
   if (!is_string($fullName) || trim($fullName) === '') {
      throw new InvalidArgumentException('O nome completo deve ser uma string não vazia.');
   }

   // Dividindo o nome completo por espaços em branco
   $nameParts = preg_split('/\s+/', trim($fullName));

   if (count($nameParts) === 0) {
      return ['firstName' => '', 'lastName' => ''];
   }

   // O primeiro nome é a primeira parte
   $firstName = $nameParts[0];

   // O restante do nome é o resto das partes unidas por espaço
   $lastName = implode(' ', array_slice($nameParts, 1));

   return ['firstName' => $firstName, 'lastName' => $lastName];
}

//$ticketDelays->saveTicketDelays(25, 10, 60, 20, '2023-09-11', 14);
//print_r($ticketDelays->totalGroupsDelay);
Html::footer();
Html::nullFooter(); // Adiciona o footer do GLPI