<?php
include ("../../../inc/includes.php");
include_once(PLUGIN_TRT16_DIR . "/inc/user_signup.class.php");

Session::checkRight("user", READ);

Html::header("Criar Usuário Externo", $_SERVER['PHP_SELF'], "admin", "plugintrt16usersignupmenu");

// Se for uma submissão do formulário
if (isset($_GET['action']) && $_GET['action'] == "run") {
    $userSignup = new PluginTRT16UserSignup();
    $fullName = splitFullName($_GET["fullName"]);
    $cpf = preg_replace('/\D/', '', $_GET["cpf"]);
    // Prepara os dados
    $input = [
        'name' => $cpf,
        'registration_number' => $cpf,
        'firstname' => $fullName['firstName'] ,
        'realname' => $fullName['lastName'],
        'email' => $_GET['email'],
        'usercategories_id' => $_GET['categoria'],
        'locations_id' => 87,
        'is_active' => 1,
        'comment' => "OAB: ". $_GET['oab']  ,
        'phone' => $_GET['phone']
    ];
    
    // Registra o usuário que está criando
    $input['glpi_users_registro_id'] = Session::getLoginUserID();
    
    $data = json_encode(['input' => [$input]]);
    
    try {
        $result = $userSignup->createUser($data);
        
        if (is_array($result) && isset($result['id'])) {
            Session::addMessageAfterRedirect(
                __('Usuário criado com sucesso. Um email será enviado com as instruções de acesso.'),
                false,
                INFO
            );
            // Limpa o formulário após sucesso
            Html::redirect($_SERVER['PHP_SELF']);
        } else {
            Session::addMessageAfterRedirect(
                __('Erro ao criar usuário: ') . (is_string($result) ? $result : json_encode($result)),
                true,
                ERROR
            );
        }
    } catch (Exception $e) {
        Session::addMessageAfterRedirect(
            __('Erro ao criar usuário: ') . $e->getMessage(),
            true,
            ERROR
        );
    }
}

// Display queued messages
Html::displayMessageAfterRedirect();

echo "<div class='center'>";
echo "<div class='card'>";
echo "<div class='card-header'><h3>Criar Usuário Externo</h3></div>";
echo "<div class='card-body'>";

// Adiciona o texto do consentimento LGPD
// Busca o texto do consentimento ativo
$consent_text = '';
$consent_query = $DB->request([
    'SELECT' => ['consentimento_texto'],
    'FROM'   => 'glpi_plugin_trt16_consentimento_versao',
    'WHERE'  => ['ativo' => 'S'],
    'LIMIT'  => 1
]);
if ($row = $consent_query->current()) {
    $consent_text = nl2br(Toolbox::stripTags($row['consentimento_texto']));
}
if (!empty($consent_text)) {
    echo "<div class='alert alert-info mb-4' style='white-space:pre-line;'>$consent_text</div>";
}

echo "<form method='get' name='form_signup' id='form_signup' action='user_internal.form.php'>
      <input type='hidden' name='action' value='run'>
      <div class='row justify-content-center'>
      <div class='col-md-12'>
         <div class='row mb-3'>
            <label class='col-sm-4 col-form-label text-end' for='cpf'>CPF (Campo utilizado para acessar o sistema):<span class='text-danger'> *</span></label>       
            <div class='col-sm-8'>
               <input type='text' class='form-control' name='cpf' id='cpf' size='15px' placeholder='000.000.000-00' maxlength='14' required>
               <span id='cpfError' class='text-danger'></span>
            </div>
         </div>
         <div class='row mb-3'>
            <label class='col-sm-4 col-form-label text-end' for='fullName'>Nome Completo:<span class='text-danger'> *</span></label>      
            <div class='col-sm-8'>
               <input type='text' class='form-control' name='fullName' required>
            </div>
         </div>
         <div class='row mb-3'>     
            <label class='col-sm-4 col-form-label text-end' for='email'>E-mail:<span class='text-danger'> *</span></label> 
            <div class='col-sm-8'>
               <input type='text' class='form-control' name='email' id='email' required> 
               <span id='emailError' class='text-danger'></span>
            </div>
         </div>
         <div class='row mb-3'>
            <label class='col-sm-4 col-form-label text-end' for='categoria'>Categoria:<span class='text-danger'> *</span></label> 
            <div class='col-sm-8'>
               <select class='form-select' name='categoria' required>
                  <option value='9'>Selecione</option>
                  <option value='13'>Advogado(a)</option>
                  <option value='12'>Aposentado(a)/Pensionista</option>
                  <option value='14'>Ministério Público</option>
                  <option value='16'>Perito(a)/Tradutor(a)/Intérprete</option>
                  <option value='15'>Estudante</option>
                  <option value='9'>Outro</option>
               </select>
            </div>
         </div>
         <div class='row mb-3'>
            <label class='col-sm-4 col-form-label text-end' for='oab'>OAB:</label> 
            <div class='col-sm-8'>
               <input type='text' class='form-control' size='15px' name='oab' placeholder='UF999999'> 
            </div>
         </div>
         <div class='row mb-3'>
            <label class='col-sm-4 col-form-label text-end' for='phone'>Telefone para contato:</label> 
            <div class='col-sm-8'>
               <input type='text' class='form-control' size='15px' name='phone' placeholder='(99) 99999-9999' pattern='[0-9() ]*'> 
            </div>
         </div>
         <div class='row'>
            <div class='col-sm-8 offset-sm-4'>
               <button type='submit' class='btn btn-primary px-4'>Salvar</button>
            </div>
         </div>
      </div>
      </div>
   </form>";

echo "</div></div></div>";

// Script para validação de CPF e formatação
echo "<script>
document.addEventListener('DOMContentLoaded', function () {
   const cpfInput = document.getElementById('cpf');
   const emailInput = document.getElementById('email');
   const form = document.getElementById('form_signup');
   const cpfError = document.getElementById('cpfError');
   const emailError = document.getElementById('emailError');

   // Função para aplicar a máscara de CPF
   cpfInput.addEventListener('input', function () {
      let cpf = cpfInput.value.replace(/\D/g, '');
      cpf = cpf.replace(/(\d{3})(\d)/, '$1.$2');
      cpf = cpf.replace(/(\d{3})(\d)/, '$1.$2');
      cpf = cpf.replace(/(\d{3})(\d{1,2})$/, '$1-$2');
      cpfInput.value = cpf;
   });

   // Função para validar CPF e Email
   form.addEventListener('submit', function(event) {
      event.preventDefault();
      cpfError.textContent = '';
      emailError.textContent = '';

      const cpf = cpfInput.value.replace(/\D/g, '');
      const email = emailInput.value;

      if (!isValidCPF(cpf)) {
         cpfError.textContent = 'CPF inválido. Por favor, insira um CPF válido.';
         return false;
      }

      if (!isValidEmail(email)) {
         emailError.textContent = 'Email inválido. Por favor, insira um email válido.';
         return false;
      }

      form.submit();
   });

   // Função para validar o CPF
   function isValidCPF(cpf) {
      if(cpf.length == 0) return true; 
      if (cpf.length !== 11 || /^(\d)\1+$/.test(cpf)) {
         return false;
      }

      let soma = 0;
      let resto;
      for (let i = 1; i <= 9; i++) {
         soma += parseInt(cpf.substring(i - 1, i)) * (11 - i);
      }
      resto = (soma * 10) % 11;

      if ((resto === 10) || (resto === 11)) resto = 0;
      if (resto !== parseInt(cpf.substring(9, 10))) return false;

      soma = 0;
      for (let i = 1; i <= 10; i++) {
         soma += parseInt(cpf.substring(i - 1, i)) * (12 - i);
      }
      resto = (soma * 10) % 11;

      if ((resto === 10) || (resto === 11)) resto = 0;
      if (resto !== parseInt(cpf.substring(10, 11))) return false;

      return true;
   }

   // Função para validar o Email
   function isValidEmail(email) {
      const re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      return re.test(email);
   }
});
</script>";

Html::footer(); 

function splitFullName($fullName) {
   // Verifica se a entrada é uma string não vazia
   if (!is_string($fullName) || trim($fullName) === '') {
      throw new InvalidArgumentException('O nome completo deve ser uma string não vazia.');
   }

   // Dividindo o nome completo por espaços em branco
   $nameParts = preg_split('/\s+/', trim($fullName));

   if (count($nameParts) === 0) {
      return ['firstName' => '', 'lastName' => ''];
   }

   // O primeiro nome é a primeira parte
   $firstName = $nameParts[0];

   // O restante do nome é o resto das partes unidas por espaço
   $lastName = implode(' ', array_slice($nameParts, 1));

   return ['firstName' => $firstName, 'lastName' => $lastName];
}