<?php
/**
 * Endpoint: /plugins/trt16/front/ticket_satisfaction.form.php
 * Recebe POST com JSON: {"tickets_id": 569 , "date_answered": "2025-10-24 12:25:56", "satisfaction": 5 , "comment": "estou satisfeito"}
 * Insere na tabela glpi_ticketsatisfactions
 */

include_once("../../../inc/includes.php");

header('Content-Type: application/json');

try {
    // --- Autenticação estilo API GLPI ---
    $headers = getallheaders();
    $appToken = isset($headers['App-Token']) ? $headers['App-Token'] : (isset($headers['app-token']) ? $headers['app-token'] : null);
    $userToken = isset($headers['Authorization']) ? $headers['Authorization'] : (isset($headers['authorization']) ? $headers['authorization'] : null);

// Configure seus tokens válidos aqui (ou busque do config)
$validAppToken = 'ePYgkMgaSw1i78hGctmtIRxV62dz6RxT5866QmJs';
$validUserToken = 'user_token SaxbHsWmtQAbdCVIaWIFILrcqwvx7uRc9Vgz6OX8';

if ($appToken !== $validAppToken || $userToken !== $validUserToken) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

// --- Somente POST ---
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method Not Allowed']);
    exit;
}

// --- Lê o corpo JSON ---
$input = file_get_contents('php://input');
$data = json_decode($input, true);

if (!is_array($data)) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid JSON']);
    exit;
}

// --- Validação básica ---
$required = ['tickets_id', 'date_answered', 'rating', 'comment'];
foreach ($required as $field) {
    if (!isset($data[$field])) {
        http_response_code(400);
        echo json_encode(['error' => "Missing field: $field"]);
        exit;
    }
}

// --- Monta dados para inserção ---
$insert = [
    'tickets_id'   => (int)$data['tickets_id'],
    'items_id'   => (int)$data['tickets_id'],
    'itemtype'   => 'Ticket',
    'date_answered'=> $data['date_answered'],
    'rating'       => (int)$data['rating'],
    'comment'      => $data['comment']
];

// --- Insere ou atualiza no banco ---
global $DB;

// Verifica se já existe registro para o tickets_id e date_answered
$existing = $DB->request([
    'SELECT' => ['id'],
    'FROM'   => 'glpi_plugin_trt16_satisfactions',
    'WHERE'  => [
        'tickets_id' => $insert['tickets_id'],
        'date_answered' => $insert['date_answered']
    ],
    'LIMIT'  => 1
])->current();

if ($existing && isset($existing['id'])) {
    // Atualiza registro existente
    $update = $DB->update(
        'glpi_plugin_trt16_satisfactions',
        $insert,
        [ 'id' => $existing['id'] ]
    );
    if ($update !== false) {
        echo json_encode(['success' => true, 'id' => $existing['id'], 'updated' => true]);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'DB Update failed', 'details' => $DB->error()]);
    }
} else {
    // Insere novo registro
    if ($DB->insert('glpi_plugin_trt16_satisfactions', $insert)) {
        echo json_encode(['success' => true, 'created' => true]);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'DB Insert failed', 'details' => $DB->error()]);
    }
} 
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Internal Server Error', 'details' => $e->getMessage()]);
}

