<?php
include('../../../inc/includes.php');

Session::checkRight("config", UPDATE);

global $DB;

// Processa POST para adicionar nova versão
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['consentimento_texto'])) {
    $texto = trim($_POST['consentimento_texto']);
    $ativo = isset($_POST['ativo']) && $_POST['ativo'] == 'S' ? 'S' : 'N';
    if ($ativo === 'S') {
        // Desativa todas as outras versões
        $DB->update('glpi_plugin_trt16_consentimento_versao', ['ativo' => 'N'], ['id' => ['>', 0]]);
    }
    $DB->insert('glpi_plugin_trt16_consentimento_versao', [
        'consentimento_texto' => $texto,
        'ativo' => $ativo
    ]);
    Html::redirect($_SERVER['REQUEST_URI']);
}

// Ativar/desativar versão
if (isset($_GET['ativar']) && is_numeric($_GET['ativar'])) {
    $id = intval($_GET['ativar']);
    // Desativa todas
    $DB->update('glpi_plugin_trt16_consentimento_versao', ['ativo' => 'N'], ['id' => ['>', 0]]);
    // Ativa a selecionada
    $DB->update('glpi_plugin_trt16_consentimento_versao', ['ativo' => 'S'], ['id' => $id]);
    Html::redirect($_SERVER['PHP_SELF']);
}

Html::header(__('Versões de Consentimento', 'trt16'), $_SERVER['PHP_SELF'], 'config', 'plugins', 'trt16');

echo '<h2>'.__('Cadastro de Versões de Consentimento', 'trt16').'</h2>';

echo '<form method="POST" action="">';
echo Html::hidden('_glpi_csrf_token', ['value' => Session::getNewCSRFToken()]);
echo '<table class="tab_cadre">';
echo '<tr><th>'.__('Texto do Consentimento', 'trt16').'</th><th>'.__('Ativo', 'trt16').'</th><th></th></tr>';
echo '<tr>';
echo '<td><textarea name="consentimento_texto" rows="4" cols="80" required></textarea></td>';
echo '<td><select name="ativo"><option value="S">Sim</option><option value="N">Não</option></select></td>';
echo '<td><button type="submit" class="submit">'.__('Adicionar', 'trt16').'</button></td>';
echo '</tr>';
echo '</table>';
echo '</form>';

// Lista versões já cadastradas
echo '<h3>'.__('Versões já cadastradas', 'trt16').'</h3>';
$versoes = $DB->request([
    'FROM' => 'glpi_plugin_trt16_consentimento_versao',
    'ORDER' => 'id DESC'
]);
echo '<table class="tab_cadre">';
echo '<tr><th>ID</th><th>'.__('Texto', 'trt16').'</th><th>'.__('Ativo', 'trt16').'</th><th>'.__('Ações', 'trt16').'</th></tr>';
foreach ($versoes as $v) {
    echo '<tr>';
    echo '<td>'.htmlspecialchars($v['id']).'</td>';
    echo '<td style="max-width:400px;white-space:pre-wrap;">'.nl2br(htmlspecialchars($v['consentimento_texto'])).'</td>';
    echo '<td>'.($v['ativo'] == 'S' ? '<b style="color:green">Sim</b>' : 'Não').'</td>';
    echo '<td>';
    if ($v['ativo'] != 'S') {
        echo '<a href="?ativar='.$v['id'].'" class="vsubmit">'.__('Ativar', 'trt16').'</a>';
    } else {
        echo '<span style="color:gray">'.__('Ativo', 'trt16').'</span>';
    }
    echo '</td>';
    echo '</tr>';
}
echo '</table>';

Html::footer(); 